/*
 * callSL.sql
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten blok ilustruje, jak wywoywa nalece do pakietw procedury przyjmujce parametry
 */
 
set serveroutput on
DECLARE
  v_BooksInStock InventoryOps.t_ISBNTable;
  v_NumBooks BINARY_INTEGER;
BEGIN
  -- Zapenianie tabeli jzyka PL/SQL numerami ISBN dostpny ksiek
  InventoryOps.StatusList('DOSTEPNY', v_BooksInStock, v_NumBooks);

  -- Wywietlanie tych numerw 
  FOR v_LoopCounter IN 1..v_NumBooks LOOP
    DBMS_OUTPUT.PUT_LINE('Ksiazka o ISBN ' || v_BooksInStock(v_LoopCounter) ||
                         ' jest dostepna');
  END LOOP;
END;
/
