/*
 * Random.sql.
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ilustruje inicjowanie pakietu
 */
 

CREATE OR REPLACE PACKAGE Random AS
  -- Generator liczb losowych. Dziaa wedug tego samego algorytmu, 
  -- co funkcja rand() w jzyku C

  -- Suy do zmiany ziarna.  To samo ziarno prowadzi
  -- do wygenerowania tej samej sekwencji liczb losowych
  PROCEDURE ChangeSeed(p_NewSeed IN NUMBER);

  -- Zwraca losow liczb cakowit z przedziau od 1 do 32767
  FUNCTION Rand RETURN NUMBER;

  -- Dziaa tak samo jak Rand, ale ma proceduralny interfejs 
  PROCEDURE GetRand(p_RandomNumber OUT NUMBER);

  -- Zwraca losow liczb cakowit z przedziau od 1 do p_MaxVal
  FUNCTION RandMax(p_MaxVal IN NUMBER) RETURN NUMBER;

  -- Dziaa tak samo jak RandMax, ale ma proceduralny interfejs 
  PROCEDURE GetRandMax(p_RandomNumber OUT NUMBER,
                       p_MaxVal IN NUMBER);
END Random;
/

CREATE OR REPLACE PACKAGE BODY Random AS

  /* Suy do obliczania nastpnych liczb */
  v_Multiplier  CONSTANT NUMBER := 22695477;
  v_Increment   CONSTANT NUMBER := 1;

  /* Ziarno uywane do generowania sekwencji liczb losowych */
  v_Seed        number := 1;

  PROCEDURE ChangeSeed(p_NewSeed IN NUMBER) IS
  BEGIN
    v_Seed := p_NewSeed;
  END ChangeSeed;

  FUNCTION Rand RETURN NUMBER IS
  BEGIN
    v_Seed := MOD(v_Multiplier * v_Seed + v_Increment,
                  (2 ** 32));
    RETURN BITAND(v_Seed/(2 ** 16), 32767);
  END Rand;

  PROCEDURE GetRand(p_RandomNumber OUT NUMBER) IS
  BEGIN
    -- Wywoanie funkcji Rand, ktra zwraca warto
    p_RandomNumber := Rand;
  END GetRand;

  FUNCTION RandMax(p_MaxVal IN NUMBER) RETURN NUMBER IS
  BEGIN
    RETURN MOD(Rand, p_MaxVal) + 1;
  END RandMax;

  PROCEDURE GetRandMax(p_RandomNumber OUT NUMBER,
                       p_MaxVal IN NUMBER) IS
  BEGIN
    -- Wywoanie funkcji RandMax, ktra zwraca warto
    p_RandomNumber := RandMax(p_MaxVal);
  END GetRandMax;

BEGIN
  /* Inicjowanie pakietu.  Polega na przypisaniu do ziarna
     biecego czasu w sekundach */
  ChangeSeed(TO_NUMBER(TO_CHAR(SYSDATE, 'SSSSS')));
END Random;
/
