/*
 * RaiseError.sql
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje dziaanie wyjtkw zgaszanych w
 * podprogramach
 */
 
/* Ilustruje dziaanie parametrw OUT przy braku obsugi
 * wyjtku. Jeli parametr p_Raise ma warto TRUE, program zgasza
 * nieobsugiwany wyjtek. Jeli p_Raise ma warto FALSE, procedura 
 * udanie koczy dziaanie
 */
CREATE OR REPLACE PROCEDURE RaiseError (
  p_Raise IN BOOLEAN,
  p_ParameterA OUT NUMBER) AS
BEGIN
  p_ParameterA := 7;

  IF p_Raise THEN
    /* Cho program przypisa 7 do p_ParameterA, nieobsuony wyjtek
     * powoduje natychmiastowe zwrcenie sterowania bez 
     * przypisania liczby 7 do argumentu powizanego z 
     * p_ParameterA
     */
    RAISE DUP_VAL_ON_INDEX;
  ELSE
    -- Zwraca sterowanie bez zgaszania bdw. Powoduje to przypisanie liczby 7 do
    -- argumentu
    RETURN;
  END IF;
END RaiseError;
/

set serveroutput on

-- Ten blok demonstruje dziaanie zmiennych w trybie OUT
-- przy zgaszaniu wyjtkw
DECLARE
  v_Num NUMBER := 1;
BEGIN
  DBMS_OUTPUT.PUT_LINE('Wartosc przed pierwszym wywolaniem: ' || v_Num);
  RaiseError(FALSE, v_Num);
  DBMS_OUTPUT.PUT_LINE('Wartosc po udanym wywolaniu: ' || v_Num);
  DBMS_OUTPUT.PUT_LINE('');

  v_Num := 2;
  DBMS_OUTPUT.PUT_LINE('Wartosc przed drugim wywolaniem: ' || v_Num);
  RaiseError(TRUE, v_Num);
EXCEPTION
  WHEN OTHERS THEN
    DBMS_OUTPUT.PUT_LINE('Wartosc po nieudanym wywolaniu: ' || v_Num);
END;
/
