/*
 * CopyFast.sql
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje popraw wydajnoci dziki zastosowaniu modyfikatora NOCOPY
 */
 
CREATE OR REPLACE PACKAGE CopyFast AS
  -- Tablica asocjacyjna ksiek
  TYPE BookArray IS
    TABLE OF books%ROWTYPE;

  -- Trzy procedury przyjmujce parametr w postaci tablicy BookArray w 
  -- odmienny sposb. Nie wykonuj adnych operacji
  PROCEDURE PassBooks1(p_Parameter IN BookArray);
  PROCEDURE PassBooks2(p_Parameter IN OUT BookArray);
  PROCEDURE PassBooks3(p_Parameter IN OUT NOCOPY BookArray);

  -- Procedura testowa
  PROCEDURE Go;
END CopyFast;
/

CREATE OR REPLACE PACKAGE BODY CopyFast AS
  PROCEDURE PassBooks1(p_Parameter IN BookArray) IS
  BEGIN
    NULL;
  END PassBooks1;

  PROCEDURE PassBooks2(p_Parameter IN OUT BookArray) IS
  BEGIN
    NULL;
  END PassBooks2;

  PROCEDURE PassBooks3(p_Parameter IN OUT NOCOPY BookArray) IS
  BEGIN
    NULL;
  END PassBooks3;

  PROCEDURE Go IS
    v_BookArray BookArray := BookArray(NULL);
    v_Time1 NUMBER;
    v_Time2 NUMBER;
    v_Time3 NUMBER;
    v_Time4 NUMBER;
  BEGIN
    -- Zapenienie tablicy przy uyciu 50001 kopii rekordu
    SELECT *
      INTO v_BookArray(1)
      FROM books
      WHERE ISBN = '72230665';
    v_BookArray.EXTEND(50000, 1);

    -- Wywoanie kadej wersji procedury PassBooks i pomiar czasu jej wykonania.
    -- Czas zwraca DBMS_UTILITY.GET_TIME w
    -- w setnych sekundy
    v_Time1 := DBMS_UTILITY.GET_TIME;
    PassBooks1(v_BookArray);
    v_Time2 := DBMS_UTILITY.GET_TIME;
    PassBooks2(v_BookArray);
    v_Time3 := DBMS_UTILITY.GET_TIME;
    PassBooks3(v_BookArray);
    v_Time4 := DBMS_UTILITY.GET_TIME;

    -- Wywietlenie wynikw
    DBMS_OUTPUT.PUT_LINE('Czas przekazywania w trybie IN: ' ||
                         TO_CHAR((v_Time2 - v_Time1) / 100));
    DBMS_OUTPUT.PUT_LINE('Czas przekazywania w trybie IN OUT: ' ||
                         TO_CHAR((v_Time3 -   v_Time2) / 100));
    DBMS_OUTPUT.PUT_LINE('Czas przekazywania w trybie IN OUT NOCOPY: ' ||
                         TO_CHAR((v_Time4 - v_Time3) / 100));
  END Go;
END CopyFast;
/

BEGIN
  CopyFast.Go();
END;
/
