/*
 * AddNewBook.sql
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ta procedura wstawia now ksik do tabeli books.
 * Skrypt demonstruje take dziaanie parametrw domylnych.
 */
 
CREATE OR REPLACE PROCEDURE AddNewBook(
  p_ISBN IN books.ISBN%TYPE,
  p_Category IN books.category%TYPE := 'Oracle Server',
  p_Title IN books.title%TYPE,
  p_NumPages IN books.num_pages%TYPE,
  p_Price IN books.price%TYPE,
  p_Copyright IN books.copyright%TYPE DEFAULT
    TO_NUMBER(TO_CHAR(SYSDATE, 'YYYY')),
  p_Author1 IN books.author1%TYPE,
  p_Author2 IN books.author2%TYPE := NULL,
  p_Author3 IN books.author3%TYPE := NULL) AS
  
BEGIN
  -- Wstawianie do tabeli nowego wiersza przy uyciu
  -- podanych parametrw
  INSERT INTO books (isbn, category, title, num_pages, price,
                     copyright, author1, author2, author3)
  VALUES (p_ISBN, p_Category, p_Title, p_NumPages, p_Price,
          p_Copyright, p_Author1, p_Author2, p_Author3);
END AddNewBook;
/

-- Nie trzeba przekazywa wartoci parametrw author2 i author3,
-- poniewa maj one wartoci domylne:
BEGIN
  AddNewBook('0000000000', 'Oracle Basics', 'A Really Nifty Book',
             500, 34.99, 2004, 1);
END;
/

ROLLBACK;

-- Ten sam przykad z zastosowaniem notacji bazujcej na nazwach:
BEGIN
  AddNewBook(p_ISBN => '0000000000',
             p_Category => 'Oracle Basics',
             p_Title => 'A Really Nifty Book',
             p_NumPages => 500,
             p_Price => 34.99,
             p_Copyright => 2004,
             p_Author1 => 1);
END;
/

ROLLBACK;

-- Wykorzystanie wszystkich wartoci domylnych:
BEGIN
  AddNewBook(p_ISBN => '0000000000',
             p_Title => 'A Really Nifty Book',
             p_NumPages => 500,
             p_Price => 34.99,
             p_Author1 => 1);
END;
/

ROLLBACK;
