/*
 * VerifyAuthors.sql
 * Rozdzia 7, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ta procedura demonstruje uywanie funkcji RAISE_APPLICATION_ERROR
 */
 

/* Sprawdza, czy przekazane dane o autorach umoliwiaj dodanie ksiki
   do bazy. Zgasza bdy w nastpujcych sytuacjach:
     * author1 ma warto null;
     * dowolny z autorw nie istnieje w tabeli authors;
     * identyfikatory autorw powtarzaj si.
   Jeli dane autorw s poprawne, procedura koczy dziaanie bez
   zgaszania bdw */

CREATE OR REPLACE PROCEDURE VerifyAuthors(
  p_Author1 IN books.author1%TYPE,
  p_Author2 IN books.author2%TYPE,
  p_Author3 IN books.author3%TYPE) AS

  v_AuthorCount NUMBER;
BEGIN
  /* Najpierw sprawdza, czy wszyscy autorzy znajduj si w tabeli authors */
  IF p_Author1 IS NULL THEN
    RAISE_APPLICATION_ERROR(-20000, 'Author1 nie moe miec wartosci NULL');
  ELSE
    SELECT COUNT(*)
      INTO v_AuthorCount
      FROM authors
      WHERE id = p_Author1;
    IF v_AuthorCount = 0 THEN
      RAISE_APPLICATION_ERROR(-20001,
        'Author1 ' || p_Author1 || ' nie istnieje');
    END IF;
  END IF;

  IF p_Author2 IS NOT NULL THEN
    SELECT COUNT(*)
      INTO v_AuthorCount
      FROM authors
      WHERE id = p_Author2;
    IF v_AuthorCount = 0 THEN
      RAISE_APPLICATION_ERROR(-20001,
        'Author2 ' || p_Author2 || ' nie istnieje');
    END IF;
  END IF;

  IF p_Author3 IS NOT NULL THEN
    SELECT COUNT(*)
      INTO v_AuthorCount
      FROM authors
      WHERE id = p_Author3;
    IF v_AuthorCount = 0 THEN
      RAISE_APPLICATION_ERROR(-20001,
        'Author3 ' || p_Author3 || ' nie istnieje');
    END IF;
  END IF;
  
  /* Nastpnie sprawdza, czy identyfikatory autorw nie powtarzaj si */
  IF p_Author1 = p_Author2 THEN
    RAISE_APPLICATION_ERROR (-20002,
      'Author1 ' || p_Author1 || ' i author2 ' || p_Author2 ||
      ' powtarzaja sie');
  ELSIF p_Author1 = p_Author3 THEN
    RAISE_APPLICATION_ERROR (-20002,
      'Author1 ' || p_Author1 || ' i author3 ' || p_Author3 ||
      ' powtarzaja sie');
  ELSIF p_Author2 = p_Author3 THEN
    RAISE_APPLICATION_ERROR (-20002,
      'Author2 ' || p_Author2 || ' i author3 ' || p_Author3 ||
      ' powtarzaja sie');
  END IF;  
END VerifyAuthors;
/

-- Trzy pierwsze wywoania powoduj bdy
BEGIN VerifyAuthors(NULL, NULL, NULL); END;
/
BEGIN VerifyAuthors(30, 40, NULL); END;
/
BEGIN VerifyAuthors(30, 30, 1); END;
/

-- Jednak te wiersze wykonaj si poprawnie
BEGIN VerifyAuthors(30, NULL, NULL); END;
/
BEGIN VerifyAuthors(30, 14, 8); END;
/

-- Ten blok ilustruje dziaanie wbudowanego wyyjtku
BEGIN
  RAISE NO_DATA_FOUND;
END;
/
