/*
 * OutOfScope.sql
 * Rozdzia 7, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje zasig wyjtkw
 */

BEGIN
  DECLARE
    e_UserDefinedException EXCEPTION;
  BEGIN
    RAISE e_UserDefinedException;
  END;
EXCEPTION
     /* e_UserDefinedException jest poza  zasigiem - moe go obsuy
        wycznie blok obsugi OTHERS */
     WHEN OTHERS THEN
       /* Ponowne zgoszenie wyjtku, co powoduje przekazanie go do
          rodowiska wywoania */
    RAISE;
END;
/

CREATE OR REPLACE PACKAGE Globals AS
/* Ten pakiet zawiera deklaracje globalne. Zadeklarowane tu obiekty s
   dostpne przy uyciu kwalifikatora w innych blokach i procedurach. 
   Warto zauway, e pakiet ten nie ma ciaa. */

  /* Wyjtek zdefiniowany przez uytkownika */
  e_UserDefinedException EXCEPTION;
END Globals;
/

BEGIN
  BEGIN
    RAISE Globals.e_UserDefinedException;
  END;
EXCEPTION
  /* Poniewa wyjtek e_UserDefinedException nadal jest widoczny, mona obsuy go
     bezporednio */
  WHEN Globals.e_UserDefinedException THEN
    /* Ponowne zgoszenie wyjtku, ktry zostanie przekazany do 
       rodowiska wywoania */
    RAISE;
END;
/
