/*
 * varray_dml2.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje aktualizowanie tablic varray
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Porzdkowanie rodowiska
BEGIN

  FOR i IN (SELECT   null
            FROM     addresses
            WHERE    address_id = 11) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM addresses WHERE address_id = 11';
  END LOOP;

  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 11) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 11';
  END LOOP;

  COMMIT;

END;
/

-- Wstawianie danych do tabeli individuals z powodu ograniczenia zwizanego z kluczem nadrzdnym
INSERT
INTO     individuals
VALUES
('11'
,'Jan'
,''
,'Kowalski');

-- Wstawianie danych do tabeli addresses przy uyciu tablicy varray
INSERT
INTO     addresses
VALUES
(11
,11
,address_varray
  ('Biuro senatora Kowalskiego'
  ,'Zachodnia 1'
  ,'Apartament 200')
,'Warszawa'
,'MAZ'
,'85-701'
,'PL');

-- Wstawianie danych do tabeli addresses przy uyciu tablicy varray
UPDATE   addresses
SET      street_address = 
           address_varray('Biuro senatora Kowalskiego'
                         ,'Wschodnia 7'
                         ,'Apartament 1150')
WHERE    address_id = 11;

CREATE OR REPLACE TYPE varray_nested_table
IS TABLE OF VARCHAR2(30 CHAR);
/

SELECT   column_value
FROM     THE (SELECT   CAST(street_address AS varray_nested_table)
              FROM     addresses
              WHERE    address_id = 11);
