/*
 * varray_dml1.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt wstawia dane do tablicy varray i wczytuje je
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Porzdkowanie rodowiska
BEGIN

  FOR i IN (SELECT   null
            FROM     addresses
            WHERE    address_id = 11) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM addresses WHERE address_id = 11';
  END LOOP;

  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 11) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 11';
  END LOOP;

  COMMIT;

END;
/

-- Wstawianie danych do tabeli individuals z powodu ograniczenia zwizanego z kluczem nadrzdnym
INSERT
INTO     individuals
VALUES
('11'
,'John'
,''
,'McCain');

-- Wstawianie danych do tabeli addresses przy uyciu tablicy varray
INSERT
INTO     addresses
VALUES
(11
,11
,address_varray
  ('Office of Senator McCain'
  ,'450 West Paseo Redondo'
  ,'Suite 200')
,'Tucson'
,'AZ'
,'85701'
,'USA');

-- Zwyka instrukcja SELECT
SELECT   street_address
FROM     addresses;

-- Typ danych bazujcy na tablicy varray
CREATE OR REPLACE TYPE varray_nested_table
IS TABLE OF VARCHAR2(30 CHAR);
/


-- Zastosowanie SQL*Plus do sformatowania danych wyjciowych
COL column_value FORMAT A30

-- Wywietlenie listy elementw tablicy VARRAY
SELECT   column_value
FROM     THE (SELECT   CAST(street_address AS
                            varray_nested_table)
              FROM     addresses
              WHERE    address_id = 11);
