/*
 * nestedtable_dml4.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje aktualizacj elementw tabeli zagniedonej
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Porzdkowanie rodowiska
BEGIN

  FOR i IN (SELECT   null
            FROM     addresses
            WHERE    address_id = 22) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM addresses WHERE address_id = 22';
  END LOOP;

  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 22) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 22';
  END LOOP;

  COMMIT;

END;
/

-- Wstawianie danych do tabeli individuals z powodu ograniczenia zwizanego z kluczem nadrzdnym
INSERT
INTO     individuals
VALUES
('22'
,'Bolko'
,''
,'Opolski');

-- Wstawianie danych do tabeli addresses przy uyciu tabeli zagniedonej
INSERT
INTO     addresses
VALUES
(22
,22
,address_table('Biuro senatora Opolskiego')
,'Opole'
,'OPO'
,'02-203'
,'PL');

-- Blok anonimowy aktualizujcy elementy tabeli zagniedonej w kodzie PL/SQL
DECLARE

  -- Definiowanie typu rekordowego reprezentujcego wiersze tabeli addresses
  TYPE address_type IS RECORD
  (address_id          INTEGER
  ,individual_id       INTEGER
  ,street_address      ADDRESS_TABLE
  ,city                VARCHAR2(20 CHAR)
  ,state               VARCHAR2(20 CHAR)
  ,postal_code         VARCHAR2(20 CHAR)
  ,country_code        VARCHAR2(10 CHAR));

  -- Definicja zmiennej typu rekordowego odpowiadajcego tabeli addresses
  address              ADDRESS_TYPE;

  -- Definicja kursora zwracajcego warto %ROWTYPE 
  CURSOR get_street_address
    (address_id_in      INTEGER) IS
    SELECT   *
    FROM     addresses
    WHERE    address_id = address_id_in;

BEGIN

  -- Otwarcie kursora 
  OPEN  get_street_address(22);

  -- Pobranie danych do zmiennej typu rekordowego 
  FETCH get_street_address
  INTO  address;

  -- Zamknicie kursora
  CLOSE get_street_address;

  -- Przydzia pamici dla elementw 
  FOR i IN 2..3 LOOP
    address.street_address.EXTEND;
  END LOOP;

  -- Usunicie zawartoci pierwszego elementu zmiennej typu tabeli zagniedonej   
  address.street_address(2) := 'Biurowiec NOT-u';
  address.street_address(3) := 'Apartament 2400';

  -- Aktualizacja wartoci kolumny tabeli  
  UPDATE   addresses
  SET      street_address = address.street_address
  WHERE    address_id = 22;

END;
/

-- Tworzenie typu do wywietlania sformatowanych wartoci tabeli zagniedonej
CREATE OR REPLACE TYPE varray_nested_table
IS TABLE OF VARCHAR2(30 CHAR);
/

-- Zapytanie do kolumny column_value
SELECT   column_value
FROM     THE (SELECT   CAST(street_address AS varray_nested_table)
              FROM     addresses
              WHERE    address_id = 22);
