/*
 * nestedtable_dml3.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje aktualizowanie elementw tabeli zagniedonej
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Porzdkowanie rodowiska
BEGIN

  FOR i IN (SELECT   null
            FROM     addresses
            WHERE    address_id = 21) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM addresses WHERE address_id = 21';
  END LOOP;

  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 21) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 21';
  END LOOP;

  COMMIT;

END;
/

-- Wstawianie danych do tabeli individuals z powodu ograniczenia zwizanego z kluczem nadrzdnym
INSERT
INTO     individuals
VALUES
('21'
,'Jan'
,''
,'Kowalski');

-- Wstawianie danych do tabeli addresses przy uyciu tabeli zagniedonej
INSERT
INTO     addresses
VALUES
(21
,21
,address_table
  ('Biuro senatora Kowalskiego'
  ,'Zachodnia 1'
  ,'Apartament 200')
,'Warszawa'
,'MAZ'
,'85-701'
,'PL');

-- Zatwierdzanie dotychczasowych operacji
COMMIT;

-- Aktualizacja wartoci kolumny bezporednio w kodzie SQL
UPDATE   THE (SELECT   street_address
              FROM     addresses
              WHERE    address_id = 21)
SET      column_value = 'Biuro senatora Jana Kowalskiego'
WHERE    column_value = 'Biuro senatora Kowalskiego';

-- Wywietlanie listy elementw tabeli zagniedonej
SELECT   column_value
FROM     THE (SELECT   street_address
              FROM     addresses
              WHERE    address_id = 21);

-- Anulowanie aktualizacji
ROLLBACK;

-- Zapytanie o warto kolumny
SELECT   column_value
FROM     THE (SELECT   CAST(street_address AS varray_nested_table)
              FROM     addresses
              WHERE    address_id = 21);

-- Blok anonimowy aktualizujcy elementy tabeli zagniedonej
DECLARE

  -- Definiowanie nowej i dawnej wartoci
  new_value VARCHAR2(30 CHAR) :=
    'Biuro senatora Jana Kowalskiego';

  old_value VARCHAR2(30 CHAR) :=
    'Biuro senatora Kowalskiego';

  -- Instrukcja SQL obsugujca zmienne powizane
  sql_statement VARCHAR2(4000 CHAR)
    := 'UPDATE   THE (SELECT   street_address '
    || '              FROM     addresses '
    || '              WHERE    address_id = 21) '
    || 'SET      column_value = :1 '
    || 'WHERE    column_value = :2';

BEGIN

  -- Zastosowanie dynamicznego SQL do uruchomienia aktualizacji
  EXECUTE IMMEDIATE sql_statement
  USING new_value, old_value;

END;
/

-- Zapytanie o warto kolumny
SELECT   column_value
FROM     THE (SELECT   CAST(street_address AS varray_nested_table)
              FROM     addresses
              WHERE    address_id = 21);
