/*
 * create_varray3.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt definiuje tablic varray za pomoc konstruktora i trzech elementw null,
 * a nastpnie prbuje zapeni j poza trzecim elementem
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

BEGIN

  -- Jeli skrypt znajdzie wiersz, usuwa go w ptli
  FOR i IN (SELECT   null
            FROM     user_types
            WHERE    type_name = 'INTEGER_VARRAY') LOOP

    EXECUTE IMMEDIATE 'DROP TYPE integer_varray';
    COMMIT;

  END LOOP;

END;
/

CREATE OR REPLACE TYPE integer_varray
  AS VARRAY(3) OF INTEGER;
/

DECLARE

  -- Deklarowanie i inicjowanie pustego zbioru wierszy
  varray_integer INTEGER_VARRAY := integer_varray(NULL,NULL,NULL);

BEGIN

  -- Przejcie w ptli po trzech rekordach
  FOR i IN 1..3 LOOP

    -- Przypisanie wartoci do indeksowanych elementw tablicy VARRAY 
    varray_integer(i) := 10 + i;

  END LOOP;

  -- Wywietlenie nagwka
  dbms_output.put_line('Tablica VARRAY zainicjowana za pomoc wartosci.');
  dbms_output.put_line('-----------------------------------------------');

  -- Przejcie w ptli po rekordach
  FOR i IN 1..3 LOOP

    -- Wywietlenie zawartoci
    dbms_output.put     ('varray_integer ['||i||'] ');
    dbms_output.put_line('['||varray_integer(i)||']');

  END LOOP;

END;
/