/*
 * create_varray1.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt definiuje tablic varray za pomoc konstruktora i trzech wartoci null
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicja tablicy VARRAY o trzech wierszach zawierajcej liczby cakowite
  TYPE integer_varray IS VARRAY(3) OF INTEGER;

  -- Deklaracja i inicjowanie tablicy VARRAY, ktra moe zawiera wartoci NULL
  varray_integer INTEGER_VARRAY :=
    integer_varray(NULL,NULL,NULL);

BEGIN

  -- Wywietlenie nagwka
  dbms_output.put_line('Tablica VARRAY zainicjowana wartosciami NULL.');
  dbms_output.put_line('---------------------------------------------');

  -- Przejcie w ptli po trzech rekordach
  FOR i IN 1..3 LOOP

    -- Wywietlenie zawartoci
    dbms_output.put     ('varray_integer ['||i||'] ');
    dbms_output.put_line('['||varray_integer(i)||']');

  END LOOP;

  -- Przypisanie wartoci do indeksowanych elementw tablicy 
  varray_integer(1) := 11;
  varray_integer(2) := 12;
  varray_integer(3) := 13;

  -- Wywietlenie nagwka
  dbms_output.put     (CHR(10)); -- Widoczne przeamanie wiersza
  dbms_output.put_line('Tablica VARRAY zainicjowana wartosciami.');
  dbms_output.put_line('----------------------------------------');

  -- Przejcie w ptli po trzech rekordach
  FOR i IN 1..3 LOOP

    -- Wywietlenie zawartoci
    dbms_output.put_line('varray_integer ['||i||'] '
    ||                   '['||varray_integer(i)||']');

  END LOOP;

END;
/

