/*
 * create_nestedtable1.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt definiuje tabel zagniedon utworzon za pomoc trzech konstruktorw z elementem null
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicja zagniedonej tabeli acuchw znakw o zmiennej dugoci
  TYPE card_table IS TABLE OF VARCHAR2(5 CHAR);

  -- Deklaracja i inicjowanie tabeli zagniedonej o trzech wierszach
  cards CARD_TABLE := card_table(NULL,NULL,NULL);

BEGIN

  -- Wywietlanie nagwka
  dbms_output.put_line(
    'Tabela zagniezdzona zainicjowania wartosciami NULL.');
  dbms_output.put_line(
    '---------------------------------------------------');

  -- Przejcie w ptli po trzech rekordach
  FOR i IN 1..3 LOOP

    -- Wywietlenie zawartoci
    dbms_output.put     ('card_table ['||i||'] ');
    dbms_output.put_line('['||cards(i)||']');

  END LOOP;

  -- Przypisanie wartoci do indeksowanych elementw tabeli
  cards(1) := 'As';
  cards(2) := 'Dwojka';
  cards(3) := 'Trojka';

  -- Wywietlenie nagwka
  dbms_output.put     (CHR(10)); -- Widoczne przeamanie wiersza
  dbms_output.put_line(
    'Tabela zagniezdzona zainicjowania asem, dwojka i trojka.');
  dbms_output.put_line(
    '--------------------------------------------------------');

  -- Przejcie w ptli po trzech rekordach w celu wywietlenia tabeli
  FOR i IN 1..3 LOOP

    dbms_output.put_line('card_table ['||i||'] '
    ||                   '['||cards(i)||']');

  END LOOP;

END;
/

