/*
 * create_assocarray5e.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje inicjowanie i przypisywanie danych tablicy asocjacyjnej
 * przy uyciu indeksw liczbowych
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicja tablicy VARRAY zawierajcej 12 acuchw znakw 
  TYPE months_varray IS VARRAY(12) OF STRING(11 CHAR);
   
  -- Definicja tablicy asocjacyjnej acuchw znakw 
  TYPE calendar_table IS TABLE OF VARCHAR2(11 CHAR)
    INDEX BY VARCHAR2(11 CHAR);

  -- Deklaracja i tworzenie tablicy VARRAY 
  month MONTHS_VARRAY := 
    months_varray('Styczen','Luty','Marzec'
                 ,'Kwiecien','Maj','Czerwiec'
                 ,'Lipiec','Sierpien','Wrzesien'
                 ,'Pazdziernik','Listopad','Grudzien');

  -- Deklaracja zmiennej typu tablicy asocjacyjnej
  calendar CALENDAR_TABLE;

BEGIN

  -- Sprawdzenie, czy tablica calendar nie zawiera elementw
  IF calendar.COUNT = 0 THEN

    -- Wywietlenie nagwka
    DBMS_OUTPUT.PUT_LINE('Petla z przypisaniem:');
    DBMS_OUTPUT.PUT_LINE('---------------------');

    -- Przejcie w ptli po wszystkich elementach tablicy VARRAY 
    FOR i IN month.FIRST..month.LAST LOOP

      -- Przypisanie indeksu elementu tablicy VARRAY 
      -- do elementu tablicy asocjacyjnej o indeksie w postaci nazwy miesica
      calendar(month(i)) := i; 
 
      -- Wywietlenie indeksowanych elementw tablicy asocjacyjnej 
      DBMS_OUTPUT.PUT_LINE(
        'Element ['||month(i)||'] ma wartosc ['||i||']');

    END LOOP;

    -- Wywietlenie nagwka
    DBMS_OUTPUT.PUT(CHR(10));
    DBMS_OUTPUT.PUT_LINE('Petla po przypisaniu:');
    DBMS_OUTPUT.PUT_LINE('---------------------');

    -- Przejcie w ptli po wszystkich elementach tablicy asocjacyjnej 
    FOR i IN calendar.FIRST..calendar.LAST LOOP

      -- Wywietlenie indeksowanych elementw tablicy asocjacyjnej 
      DBMS_OUTPUT.PUT_LINE(
        'Element ['||i||'] ma wartosc ['||calendar(i)||']');

    END LOOP;

  END IF;

END;
/

