/*
 * bulk_collect1.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje, jak stosowa masowe pobieranie
 * danych do tablicy asocjacyjnej
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Tworzenie tabeli na potrzeby przykadu
CREATE TABLE bulk_numbers
(number_id                NUMBER              NOT NULL
,CONSTRAINT number_id_pk  PRIMARY KEY (number_id));

-- Uycie instrukcji FORALL w celu przeniesienia tablicy asocjacyjnej do tabeli 
DECLARE

  -- Definicja tablicy asocjacyjnej liczb cakowitych 
  TYPE number_table IS TABLE OF bulk_numbers.number_id%TYPE
    INDEX BY BINARY_INTEGER;

  -- Definicja zmiennej typu tablicy asocjacyjnej 
  number_list NUMBER_TABLE;

BEGIN

  -- Przejcie w ptli od 1 do 10000  i zwikszanie tablicy asocjacyjnej 
  FOR i IN 1..10000 LOOP

    -- Przypisanie liczby
    number_list(i) := i;

  END LOOP;

  -- Przejcie w ptli po wszystkich elementach w celu masowego wstawienia danych 
  FORALL i IN 1..number_list.COUNT
    INSERT
    INTO     bulk_numbers
    VALUES  (number_list(i));

  -- Zatwierdzenie rekordw
  COMMIT;

END;
/

-- Zastosowanie instrukcji BULK COLLECT w celu pobrania tabeli do
-- tablicy asocjacyjnej 
DECLARE

  -- Definicja tablicy asocjacyjnej liczb cakowitych 
  TYPE number_table IS TABLE OF bulk_numbers.number_id%TYPE
    INDEX BY BINARY_INTEGER;

  -- Definicja zmiennej typu tablicy asocjacyjnej 
  number_list NUMBER_TABLE;

BEGIN

  -- Pobranie wszystkich wierszy za pomoc BULK COLLECT
  SELECT   number_id
  BULK COLLECT
  INTO     number_list
  FROM     bulk_numbers
  ORDER BY 1;

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT_LINE('Pobieranie masowe:');
  DBMS_OUTPUT.PUT_LINE('------------------');

  -- Przejcie w ptli w celu wywietlenia elementw
  FOR i IN number_list.FIRST..number_list.LAST LOOP

    -- Wywietlenie tylko dwch pierwszych i ostatnich elementw
    IF i <= 2 OR i >= 9999 THEN

      -- Wywietlenie indeksowanego elementu z tablicy 
      DBMS_OUTPUT.PUT_LINE('Numer ['||number_list(i)||']');

    END IF;

  END LOOP;

END;
/
