/*
 * create_record6.sql
 * Rozdzia 5, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie jawnych definicji do zdefiniowania typw rekordowych
 * i zoonego typu rekordowego oraz korzystanie z typw zagniedonych
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Ten blok anonimowy gwarantuje, e klucz gwny nie zostanie naruszony
BEGIN
  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     addresses
            WHERE    address_id = 3) LOOP

    EXECUTE IMMEDIATE 'DELETE FROM addresses WHERE address_id = 3';
    COMMIT;

  END LOOP;

  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 6) LOOP

    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 6';
    COMMIT;

  END LOOP;

END;
/

-- Blok anonimowy zapisujcy rekord do wiersza
DECLARE

  -- Definicja typu rekordowego
  TYPE individual_record IS RECORD
  (individual_id   INTEGER
  ,first_name      VARCHAR2(30 CHAR)
  ,middle_initial  VARCHAR2(1 CHAR)
  ,last_name       VARCHAR2(30 CHAR));

  -- Definicja typu rekordowego
  TYPE address_record IS RECORD
  (address_id      INTEGER
  ,individual_id   INTEGER
  ,street_address1 VARCHAR2(30 CHAR)
  ,street_address2 VARCHAR2(30 CHAR)
  ,street_address3 VARCHAR2(30 CHAR)
  ,city            VARCHAR2(20 CHAR)
  ,state           VARCHAR2(20 CHAR)
  ,postal_code     VARCHAR2(20 CHAR)
  ,country_code    VARCHAR2(10 CHAR));

  -- Definicja typu rekordowego bazujcego na dwch typach rekordowych zdefiniowanych przez uytkownika
  TYPE individual_address_record IS RECORD
  (individual      INDIVIDUAL_RECORD
  ,address         ADDRESS_RECORD);

  -- Definicja zmiennej zoonego typu rekordowego zdefiniowanego przez uytkownika
  individual_address INDIVIDUAL_ADDRESS_RECORD;

  -- Definicja procedury lokalnej zarzdzajcej wstawianiem adresw
  PROCEDURE insert_address
    (address_in ADDRESS_RECORD) IS

  BEGIN

    -- Wstawianie wartoci do obiektu docelowego
    INSERT
    INTO     addresses
    VALUES
    (address_in.address_id
    ,address_in.individual_id
    ,address_in.street_address1
    ,address_in.street_address2
    ,address_in.street_address3
    ,address_in.city
    ,address_in.state
    ,address_in.postal_code
    ,address_in.country_code);

  END insert_address; 

  -- Definicja procedury lokalnej do zarzdzania wstawianiem osb
  PROCEDURE insert_individual
    (individual_in INDIVIDUAL_RECORD) IS

  BEGIN

    -- Wstawianie wartoci do tabeli
    INSERT
    INTO     individuals
    VALUES
    (individual_in.individual_id
    ,individual_in.first_name
    ,individual_in.middle_initial
    ,individual_in.last_name);

  END insert_individual; 

BEGIN

  -- Inicjowanie wartoci pl rekordu
  individual_address.individual.individual_id := 6;
  individual_address.individual.first_name := 'Konrad';
  individual_address.individual.middle_initial := '';
  individual_address.individual.last_name := 'Mazowiecki';

  -- Inicjowanie wartoci pl rekordu
  individual_address.address.address_id := 3;
  individual_address.address.individual_id := 6;
  individual_address.address.street_address1 := 'Szeroka 100';
  individual_address.address.street_address2 := '';
  individual_address.address.street_address3 := '';
  individual_address.address.city := 'Warszawa';
  individual_address.address.state := 'MAZ';
  individual_address.address.postal_code := '00-111';
  individual_address.address.country_code := 'PL';

  -- Tworzenie punktu zapisu
  SAVEPOINT addressbook;

  -- Przetwarzanie podtypw obiektowych
  insert_individual(individual_address.individual); 
  insert_address(individual_address.address); 

  -- Zatwierdzanie rekordu
  COMMIT;

EXCEPTION

  -- Wycofywanie operacji do punktu przerwania w przypadku wystpienia bdu
  WHEN OTHERS THEN
    ROLLBACK to addressbook;
    RETURN;

END;
/    
