/*
 * create_record3.sql
 * Rozdzia 5, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie jawnych definicji do zdefiniowania typw rekordowych
 * i zoonego typu rekordowego oraz korzystanie z typw zagniedonych
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Ten blok anonimowy gwarantuje, e klucz gwny nie zostanie naruszony
BEGIN
  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     addresses
            WHERE    address_id = 1) LOOP

    EXECUTE IMMEDIATE 'DELETE FROM addresses WHERE address_id = 1';
    COMMIT;

  END LOOP;

  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 3) LOOP

    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 3';
    COMMIT;

  END LOOP;

END;
/

-- Blok anonimowy zapisujcy rekord do wiersza
DECLARE

  -- Definicja typu rekordowego
  TYPE individual_record IS RECORD
  (individual_id   INTEGER
  ,first_name      VARCHAR2(30 CHAR)
  ,middle_initial  VARCHAR2(1 CHAR)
  ,last_name       VARCHAR2(30 CHAR));

  -- Definicja typu rekordowego
  TYPE address_record IS RECORD
  (address_id      INTEGER
  ,individual_id   INTEGER
  ,street_address1 VARCHAR2(30 CHAR)
  ,street_address2 VARCHAR2(30 CHAR)
  ,street_address3 VARCHAR2(30 CHAR)
  ,city            VARCHAR2(20 CHAR)
  ,state           VARCHAR2(20 CHAR)
  ,postal_code     VARCHAR2(20 CHAR)
  ,country_code    VARCHAR2(10 CHAR));

  -- Definicja typu rekordowego zawierajcego dwie zmienne typu rekordowego zdefiniowane przez uytkownika
  TYPE individual_address_record IS RECORD
  (individual      INDIVIDUAL_RECORD
  ,address         ADDRESS_RECORD);

  -- Definicja zmiennej zoonego typu rekordowego zdefiniowanego przez uytkownika
  individual_address INDIVIDUAL_ADDRESS_RECORD;

BEGIN

  -- Inicjowanie wartoci pl rekordu
  individual_address.individual.individual_id := 3;
  individual_address.individual.first_name := 'Mieszko';
  individual_address.individual.middle_initial := 'I';
  individual_address.individual.last_name := 'Wielki';

  -- Inicjowanie wartoci pl rekordu
  individual_address.address.address_id := 1;
  individual_address.address.individual_id := 3;
  individual_address.address.street_address1 := 'Wojowa';
  individual_address.address.street_address2 := '';
  individual_address.address.street_address3 := '';
  individual_address.address.city := 'Gniezno';
  individual_address.address.state := 'WIE';
  individual_address.address.postal_code := '10-001';
  individual_address.address.country_code := 'PL';

  -- Wstawianie wartoci do obiektu docelowego
  INSERT
  INTO     individuals
  VALUES
  (individual_address.individual.individual_id
  ,individual_address.individual.first_name
  ,individual_address.individual.middle_initial
  ,individual_address.individual.last_name);

  -- Wstawianie wartoci do obiektu docelowego
  INSERT
  INTO     addresses
  VALUES
  (individual_address.address.address_id
  ,individual_address.address.individual_id
  ,individual_address.address.street_address1
  ,individual_address.address.street_address2
  ,individual_address.address.street_address2
  ,individual_address.address.city
  ,individual_address.address.state
  ,individual_address.address.postal_code
  ,individual_address.address.country_code);

  -- Zatwierdzanie operacji
  COMMIT;

END;
/    
