/*
 * create_function1.sql
 * Rozdzia 5, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie typw rekordowych jako wartoci zwracanych przez funkcj
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

@create_record1.sql

-- Blok anonimowy zapisujcy rekord do wiersza
DECLARE

  -- Definicja typu rekordowego
  TYPE individual_record IS RECORD
  (individual_id   INTEGER
  ,first_name      VARCHAR2(30 CHAR)
  ,middle_initial  individuals.middle_initial%TYPE
  ,last_name       VARCHAR2(30 CHAR));

  -- Definicja zmiennej typu rekordowego
  individual INDIVIDUAL_RECORD;

  -- Definicja funkcji lokalnej zwracajcej warto typu rekordowego
  FUNCTION get_row 
    (individual_id_in INTEGER)
  RETURN INDIVIDUAL_RECORD IS

    -- Definicja kursora zwracajcego wiersz z tabeli individuals
    CURSOR c
      (individual_id_cursor INTEGER) IS
      SELECT   *
      FROM individuals
      WHERE    individual_id = individual_id_cursor;

  BEGIN

    -- Przejcie w ptli po kursorze i pobranie jednego wiersza
    FOR i IN c(individual_id_in) LOOP

      -- Zwrcenie wartoci atrybutu %ROWTYPE z tabeli INDIVIDUALS
      RETURN i;

    END LOOP;

  END get_row;

BEGIN

  -- Przypisanie wartoci zwrconej przez funkcj do zmiennej
  individual := get_row(1);
  
  -- Wywietlanie wynikw
  dbms_output.put_line(CHR(10));
  dbms_output.put_line('INDIVIDUAL_ID  : '||individual.individual_id);
  dbms_output.put_line('FIRST_NAME     : '||individual.first_name);
  dbms_output.put_line('MIDDLE_INITIAL : '||individual.middle_initial);
  dbms_output.put_line('LAST_NAME      : '||individual.last_name);

END;
/
