/*
 * TextIndex.sql
 * Rozdzia 4, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje indeksowanie przy uyciu Oracle Text
 */

exec clean_schema.trigs
exec clean_schema.procs
exec clean_schema.tables
exec clean_schema.ind

CREATE TABLE book_descriptions (
   book_description_id   NUMBER (10) PRIMARY KEY,
   isbn             VARCHAR2(10),
   description      VARCHAR2(500));

INSERT INTO book_descriptions (
   book_description_id,
   isbn,
   description)
 VALUES (
   1,
   '72230665', 
   'To podstawowe zrodo wiedzy o PL/SQL zostao poprawione i rozszerzone.
    Zawiera calkiem nowe przyklady bazujace na nowej wersji Oracle Database 10g.
    Ponadto cay kod przedstawiony w ksiazce oraz dodatkowe zagadnienia s
    dostepne na witrynie internetowej.');

commit;

PROMPT
PROMPT ** Tworzenie indeksu CONTEXT dla kolumny description
PROMPT

-- Jeli chcesz uy indeksowania tematycznego w Oracle 10gR1, zwr uwag, e baza wiedzy
--  nie jest doczana do pojedynczej instalacyjnej pyty cd. Trzeba zainstalowa take
--  pyt cd z materiaami pomocniczymi. Zwr uwag na komentarz 262701.1 na witrynie http://metalink.oracle.com

BEGIN
   ctx_ddl.create_preference ('desc_lexer', 'basic_lexer');
   ctx_ddl.set_attribute ('desc_lexer', 'index_text', 'true');
   ctx_ddl.set_attribute ('desc_lexer', 'index_themes', 'false');
END;
/

BEGIN
   ctx_ddl.create_preference ('desc_wordlist', 'basic_wordlist');
   ctx_ddl.set_attribute ('desc_wordlist', 'substring_index', 'true');
END;
/

-- Tworzenie indeksu z domylnym zestawem elementw nieindeksowanych
CREATE INDEX desc_indx ON book_descriptions(description)
INDEXTYPE IS CTXSYS.CONTEXT
PARAMETERS ( 'lexer desc_lexer 
              wordlist desc_wordlist 
              stoplist ctxsys.default_stoplist' );

PROMPT
PROMPT ** Proste zapytanie testujace indeks
PROMPT
SELECT score(1), isbn
FROM book_descriptions
WHERE CONTAINS(description, 'witrynie', 1) > 0;

SET SERVEROUTPUT ON

PROMPT
PROMPT
PROMPT ** Sprawdzanie niewrazliwosci na wielkosc znakow za pomoca prostego zapytania z literami roznej wielkosci
PROMPT

DECLARE
   v_isbn BOOK_DESCRIPTIONS.ISBN%TYPE;
   v_score NUMBER(10);
BEGIN
   
   SELECT score(1), isbn
   INTO v_score, v_isbn
   FROM book_descriptions
   WHERE CONTAINS (description, '10G or oracle', 1) > 0;

   DBMS_OUTPUT.PUT_LINE('Wynik: '||v_score||' i ISBN: '||v_isbn);

EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE(sqlerrm);
END;
/



PROMPT
PROMPT 
PROMPT ** Sprawdzanie wyszukiwania na podstawie bliskosci
PROMPT

DECLARE
   v_isbn BOOK_DESCRIPTIONS.ISBN%TYPE;
   v_score NUMBER(10);
BEGIN
   
   SELECT score(1), isbn
   INTO v_score, v_isbn
   FROM book_descriptions
   WHERE CONTAINS (description, '10g near Oracle', 1) > 0;

   DBMS_OUTPUT.PUT_LINE('Wynik: '||v_score||' i ISBN: '||v_isbn);

EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE(sqlerrm);
END;
/


SELECT isbn
FROM book_descriptions
WHERE CONTAINS(description, '10g near oracle') > 0;

SELECT isbn
FROM book_descriptions
WHERE CONTAINS(description, 'witrynie') > 3;
