/*
 * Timestamp.sql
 * Rozdzia 3, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje typy danych z rodziny TIMESTAMP
 */

exec clean_schema.trigs
exec clean_schema.procs
exec clean_schema.tables

SET SERVEROUTPUT ON

PROMPT
PROMPT ** Typ danych TIMESTAMP przechowuje daty i czas w nastepujacy sposob:
PROMPT

DECLARE
   v_datetime TIMESTAMP := SYSTIMESTAMP;
BEGIN
   DBMS_OUTPUT.PUT_LINE(v_datetime);
END;
/


PROMPT
PROMPT ** Typ TIMESTAMP WITH TIME ZONE przechowuje daty i czas
PROMPT **  nieco inaczej:
PROMPT

DECLARE
   v_datetime TIMESTAMP (3) WITH TIME ZONE := SYSTIMESTAMP;
BEGIN
   DBMS_OUTPUT.PUT_LINE(v_datetime);
END;
/


PROMPT
PROMPT ** Typ TIMESTAMP WITH LOCAL TIME ZONE przechowuje daty i czas
PROMPT **  nieco inaczej:
PROMPT

DECLARE
   v_datetime TIMESTAMP (0) WITH LOCAL TIME ZONE := SYSTIMESTAMP;
BEGIN
   DBMS_OUTPUT.PUT_LINE(v_datetime);
END;
/


