/*
 * Interval.sql
 * Rozdzia 3, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje zastosowanie typw INTERVAL
 */

exec clean_schema.trigs
exec clean_schema.procs
exec clean_schema.tables

SET SERVEROUTPUT ON

PROMPT
PROMPT ** Oszacowanie czasu pozostalego do opuszczenia collage'u przez moja corke **
PROMPT

DECLARE
   v_college_deadline TIMESTAMP;
BEGIN
   v_college_deadline := TO_TIMESTAMP('06/06/2004', 'DD/MM/YYYY') 
                         + INTERVAL '12-3' YEAR TO MONTH;

   DBMS_OUTPUT.PUT_LINE('Corka opusci collage '
                        ||v_college_deadline);
END;
/



PROMPT
PROMPT ** To rozwiazanie zwraca nieco dokladniejsza date **
PROMPT

DECLARE
   v_college_deadline TIMESTAMP;
BEGIN
   v_college_deadline := TO_TIMESTAMP('06/06/2004', 'DD/MM/YYYY') 
                         + INTERVAL '12-3' YEAR TO MONTH
                         + INTERVAL '19 9:0:0.0' DAY TO SECOND;

   DBMS_OUTPUT.PUT_LINE('Corka opuci collage '
                        ||v_college_deadline);
END;
/

