/*
 * CreateUser.sql
 * Rozdzia 16, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt tworzy uytkownika plsql na potrzeby przykadw
 *   z rozdziau 1.  Trzeba uruchomi ten skrypt z konta SYS,
 *   SYSTEM lub SYSDBA.  Mona go uruchamia wielokrotnie.
 *
 * Uytkownik plsql jest tworzony przy uyciu przestrzeni tabel USERS i TEMP.
 *   Jeli tych przestrzeni nie ma w Twoim rodowisku, zmie
 *   skrypt, aby uywa odpowiednich przestrzeni tabel.
 *
 * Zmodyfikuj ponisz warto conn_string, podajc nazw usugi sieciowej,
 *   jeli nie uywasz wartoci domylnej.
 *
 * Warto parametru file_loc musi odpowiada lokalizacji, w ktrej zapisane s wszystkie
 *   obrazy uywane w przykadach.  Zalecamy umieszczenie tych obrazw
 *   wraz z wzsystkimi przykadowymi skryptami z tego rozdziau,
 *   cho nie jest to konieczne.  cieka prowadzca do katalogu musi
 *   koczy si odpowiednim ukonikiem ("\" w systemie Windows i "/" w systamch Unix oraz Linux).
 */

DEF conn_string = lob_user/oracle
DEF username = LOB_USER
DEF default_ts = USERS
DEF temp_ts = TEMP
DEF file_loc = c:\files

-- Ponisze katalogi su do przechowywania typw LOB, a nie danych schematu.
--   Trzeba najpierw utworzy przestrzenie tabel dla schematu zgodne
--   z okrelonymi powyej nazwami.

DEF clob_datafile_loc = C:\oraclexe\app\oracle\product\10.2.0\db_1\orcl\clob_ts01.dbf
DEF blob_datafile_loc = C:\oraclexe\app\oracle\product\10.2.0\db_1\orcl\blob_ts01.dbf


SET FEEDBACK OFF SERVEROUTPUT ON VERIFY OFF TERMOUT OFF

SPOOL CreateLOBUser.log

DECLARE
   v_count       INTEGER        := 0;
   v_statement   VARCHAR2 (500);
BEGIN

   -- Usuwanie uytkownika, jeli istnieje

   SELECT COUNT (1)
     INTO v_count
     FROM dba_users
    WHERE username = UPPER ('&username');

   IF v_count != 0
   THEN
      EXECUTE IMMEDIATE ('DROP USER &username CASCADE');
   END IF;

   v_count := 0;

   -- Usuwanie katalogu, jeli istnieje

   SELECT COUNT(1)
     INTO v_count
     FROM dba_directories
    WHERE directory_name = 'BOOK_SAMPLES_LOC';

   IF v_count != 0
   THEN
      EXECUTE IMMEDIATE ('DROP DIRECTORY BOOK_SAMPLES_LOC');
   END IF;

   -- Tworzenie uytkownika lob_user

   v_statement :=
         'CREATE USER &username IDENTIFIED BY oracle'
      || ' DEFAULT TABLESPACE &default_ts'
      || ' TEMPORARY TABLESPACE &temp_ts'
      || ' QUOTA UNLIMITED ON &default_ts'
      || ' ACCOUNT UNLOCK';

   EXECUTE IMMEDIATE (v_statement);

   -- Przyznawanie uprawnie
   EXECUTE IMMEDIATE ('GRANT connect, resource TO &username');
   EXECUTE IMMEDIATE ('GRANT execute ON ctx_ddl TO &username');
   EXECUTE IMMEDIATE ('GRANT create ANY directory, drop ANY directory TO &username');

   DBMS_OUTPUT.put_line ('	');
   DBMS_OUTPUT.put_line ('Utworzono uzytkownika &username');
   DBMS_OUTPUT.put_line ('	');

   -- Tworzenie przestrzeni tabel dla typw CLOB

   v_count := 0;

   SELECT COUNT (1)
     INTO v_count
     FROM dba_tablespaces
    WHERE tablespace_name = 'CLOB_TS';

   IF v_count != 0
   THEN
      EXECUTE IMMEDIATE ('DROP TABLESPACE CLOB_TS INCLUDING CONTENTS');
   END IF;

   v_statement := 'CREATE TABLESPACE CLOB_TS DATAFILE ''&clob_datafile_loc'' '
                  || 'SIZE 5M REUSE '
                  || 'AUTOEXTEND ON NEXT 10M '
                  || 'MAXSIZE 10M DEFAULT STORAGE ('
                  || 'INITIAL 512K NEXT 512K '
                  || 'MINEXTENTS 1 MAXEXTENTS 1024'
                  || 'PCTINCREASE 0 ) ';

   EXECUTE IMMEDIATE (v_statement);

   -- Tworzenie przestrzeni tabel dla typw BLOB

   v_count := 0;

   SELECT COUNT (1)
     INTO v_count
     FROM dba_tablespaces
    WHERE tablespace_name = 'BLOB_TS';

   IF v_count != 0
   THEN
      EXECUTE IMMEDIATE ('DROP TABLESPACE BLOB_TS INCLUDING CONTENTS');
   END IF;

   v_statement := 'CREATE TABLESPACE BLOB_TS DATAFILE ''&blob_datafile_loc'' '
                  || 'SIZE 5M REUSE '
                  || 'AUTOEXTEND ON NEXT 10M '
                  || 'MAXSIZE 10M DEFAULT STORAGE ('
                  || 'INITIAL 512K NEXT 512K '
                  || 'MINEXTENTS 1 MAXEXTENTS 1024'
                  || 'PCTINCREASE 0 ) ';

   EXECUTE IMMEDIATE (v_statement);


EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.put_line (SQLERRM);
      DBMS_OUTPUT.put_line ('	');
END;
/

SET FEEDBACK ON TERMOUT ON

CREATE DIRECTORY book_samples_loc AS '&file_loc';
GRANT READ ON DIRECTORY book_samples_loc TO &username;

PROMPT
PROMPT Polaczenie z kontem &username w celu utworzenia pakietu do zarzadzania
PROMPT

CONN &conn_string

CREATE OR REPLACE PACKAGE clean_schema IS

   PROCEDURE tables;
   PROCEDURE objects;
   PROCEDURE procs;
   PROCEDURE ind;
 
END;
/


CREATE OR REPLACE PACKAGE BODY clean_schema AS

PROCEDURE tables
IS
   v_string VARCHAR2(50);
   v_tab_error EXCEPTION;
   PRAGMA EXCEPTION_INIT(v_tab_error, -942); 
BEGIN
   BEGIN
   v_string := 'DROP TABLE varray_lob';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_tab_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP TABLE book_samples';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_tab_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP TABLE long_to_lob';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_tab_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP TABLE book_samples_nls';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_tab_error
      THEN
      NULL;
   END;

END tables;

PROCEDURE objects
IS
   v_string VARCHAR2(50);
   v_obj_error EXCEPTION;
   PRAGMA EXCEPTION_INIT(v_obj_error, -4043);
BEGIN
   BEGIN
   v_string := 'DROP TYPE varray_table_obj';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_obj_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP TYPE varray_lob_obj';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_obj_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP TYPE varray_lob2_obj';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_obj_error
      THEN
      NULL;
   END;

END objects;

PROCEDURE procs
IS
   v_string VARCHAR2(50);
   v_proc_error EXCEPTION;
   PRAGMA EXCEPTION_INIT(v_proc_error, -4043);
BEGIN
   BEGIN
   v_string := 'DROP PROCEDURE lobappend';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_proc_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP PROCEDURE clob_compare';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_proc_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP PROCEDURE convert_me';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_proc_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP PROCEDURE check_file';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_proc_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP PROCEDURE check_status';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_proc_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP PROCEDURE close_file';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_proc_error
      THEN
      NULL;
   END;

   BEGIN
   v_string := 'DROP PROCEDURE close_all_files';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_proc_error
      THEN
      NULL;
   END;

END procs;

PROCEDURE ind
IS
   v_string VARCHAR2(50);
   v_index_error EXCEPTION;
   v_pref_error EXCEPTION;
   PRAGMA EXCEPTION_INIT(v_index_error, -1418);
   PRAGMA EXCEPTION_INIT(v_pref_error, -20000);
BEGIN
   BEGIN
   v_string := 'DROP INDEX lob_indx force';
   EXECUTE IMMEDIATE (v_string);
   EXCEPTION
   WHEN v_index_error
      THEN
      NULL;
   END;

   BEGIN
   ctx_ddl.drop_preference ('lob_lexer');   
   EXCEPTION
   WHEN v_pref_error
      THEN
      NULL;
   END;

   BEGIN
   ctx_ddl.drop_preference ('lob_wordlist');   
   EXCEPTION
   WHEN v_pref_error
      THEN
      NULL;
   END;

END ind;

END;
/


SPOOL OFF
