/*
 * ClobCompare.sql
 * Rozdzia 16, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt testuje funkcj DBMS_LOB.COMPARE
 */

exec CLEAN_SCHEMA.TABLES
exec CLEAN_SCHEMA.OBJECTS
exec CLEAN_SCHEMA.PROCS

PROMPT
PROMPT ** Tworzenie tabeli book_samples
PROMPT

CREATE TABLE book_samples (
   book_sample_id   NUMBER (10) PRIMARY KEY,
   isbn             CHAR(10 CHAR),
   description      CLOB,
   nls_description  NCLOB,
   book_cover       BLOB,
   chapter_title    VARCHAR2(30 CHAR),
   chapter          BFILE
)  
   LOB (book_cover) 
      STORE AS blob_seg ( TABLESPACE blob_ts
                 CHUNK 8192
                 PCTVERSION 0
                 NOCACHE
                 NOLOGGING
                 DISABLE STORAGE IN ROW)
   LOB (description, nls_description) 
   STORE AS ( TABLESPACE clob_ts
                 CHUNK 8192
                 PCTVERSION 10
                 NOCACHE
                 LOGGING
                 ENABLE STORAGE IN ROW);


PROMPT
PROMPT ** Wstawianie dwoch rekordow do tabeli book_samples
PROMPT

INSERT INTO book_samples (
   book_sample_id,
   isbn,
   description,
   nls_description,
   book_cover,
   chapter)
 VALUES (
   1,
   '72230665', 
   'To podstawowe zrodo wiedzy o PL/SQL zostalo poprawione i rozszerzone. Zawiera calkiem nowe przyklady bazujace na nowej wersji Oracle Database 10g. Ponadto caly kod przedstawiony w ksiazce oraz dodatkowe zagadnienia s dostepne na witrynie internetowej.',
   EMPTY_CLOB(),
   EMPTY_BLOB(),
   BFILENAME('BOOK_SAMPLES_LOC', '72230665.jpg'));

INSERT INTO book_samples (
   book_sample_id,
   isbn,
   description,
   nls_description,
   book_cover,
   chapter)
 VALUES (
   2,
   '72230665', 
   'To podstawowe zrodo wiedzy o PL/SQL zostalo poprawione i rozszerzone. Zawiera calkiem nowe przyklady bazujace na nowej wersji Oracle Database 10g. Ponadto caly kod przedstawiony w ksiazce oraz dodatkowe zagadnienia s dostepne na witrynie internetowej',
   EMPTY_CLOB(),
   EMPTY_BLOB(),
   BFILENAME('BOOK_SAMPLES_LOC', '72230665.jpg'));

INSERT INTO book_samples (
   book_sample_id,
   isbn,
   description,
   nls_description,
   book_cover,
   chapter)
 VALUES (
   3,
   '72230665', 
   'To podstawowe zrodo wiedzy o PL/SQL zostalo poprawione i rozszerzone. Zawiera calkiem nowe przyklady bazujace na nowej wersji Oracle Database 10g. Ponadto caly kod przedstawiony w ksiazce oraz dodatkowe zagadnienia s dostepne na witrynie internetowej.',
   EMPTY_CLOB(),
   EMPTY_BLOB(),
   BFILENAME('book_samples_loc', '72230665.jpg'));

PROMPT
PROMPT ** Tworzenie procedury CLOB_COMPARE
PROMPT

CREATE OR REPLACE PROCEDURE CLOB_COMPARE (
   v_lob1 IN OUT CLOB,
   v_lob2 IN OUT CLOB)
AS
   v_compare PLS_INTEGER := 0;
BEGIN

   DBMS_LOB.OPEN(v_lob1, DBMS_LOB.LOB_READONLY);
   DBMS_LOB.OPEN(v_lob2, DBMS_LOB.LOB_READONLY);

   v_compare := DBMS_LOB.COMPARE(v_lob1,v_lob2, 32768, 1, 1);

   DBMS_OUTPUT.PUT_LINE('Wartosc zwrocona przez COMPARE to: '||v_compare);

   IF v_compare = 0
   THEN
      DBMS_OUTPUT.PUT_LINE('=========================');
      DBMS_OUTPUT.PUT_LINE('Obiekty LOB s takie same');
      DBMS_OUTPUT.PUT_LINE('=========================');
   ELSE
      DBMS_OUTPUT.PUT_LINE('====================');
      DBMS_OUTPUT.PUT_LINE('Obiekty LOB s rozne');
      DBMS_OUTPUT.PUT_LINE('====================');
   END IF;

   DBMS_LOB.CLOSE(v_lob1);
   DBMS_LOB.CLOSE(v_lob2);
EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE(SQLERRM);
END;
/

PROMPT
PROMPT ** Porownanie kolumn CLOB
PROMPT

SET SERVEROUTPUT ON

DECLARE
   v_lob1 CLOB;
   v_lob2 CLOB;
   v_lob3 CLOB;
BEGIN
   SELECT description
   INTO v_lob1
   FROM book_samples
   WHERE book_sample_id = 1;

   SELECT description
   INTO v_lob2
   FROM book_samples
   WHERE book_sample_id = 2;

   SELECT description
   INTO v_lob3
   FROM book_samples
   WHERE book_sample_id = 3;

   DBMS_OUTPUT.PUT_LINE('Porownywanie odmiennych wartosci');
   DBMS_OUTPUT.PUT_LINE('================================');
   CLOB_COMPARE(v_lob1, v_lob2);

   DBMS_OUTPUT.PUT_LINE('Porownywanie identycznych wartosci');
   DBMS_OUTPUT.PUT_LINE('==================================');
   CLOB_COMPARE(v_lob1, v_lob3);

EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.PUT_LINE('Nie dziala!');
      DBMS_OUTPUT.PUT_LINE(SQLERRM);
END;
/