/*
 * objectView.sql
 * Rozdzia 15, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje tworzenie widokw obiektowych
 */

SET SERVEROUTPUT ON SIZE 1000000

exec clean_schema.synonyms
exec clean_schema.tables
exec clean_schema.objects

CREATE OR REPLACE TYPE discount_price_obj AS OBJECT (
   discount_rate   NUMBER (10, 4),
   price           NUMBER (10, 2),
   MEMBER FUNCTION discount_price
      RETURN NUMBER
)
INSTANTIABLE FINAL;
/

CREATE OR REPLACE TYPE BODY discount_price_obj
AS
   MEMBER FUNCTION discount_price
      RETURN NUMBER
   IS
   BEGIN
      RETURN (SELF.price * (1 - SELF.discount_rate));
   END discount_price;
END;
/

-- Tworzy tabel relacyjn inventory_tbl, ktra obejmuje
--  kolumn obiektow

CREATE TABLE inventory_tbl (
   item_id          NUMBER (10) PRIMARY KEY,
   num_in_stock     NUMBER (10),
   reorder_status   VARCHAR2 (20 CHAR),
   price            discount_price_obj)
/
-- Ponownie tworzy typ obiektowy inventory_obj, aby dopasowa go do
--  tabeli inventory_tbl w celu uycia w widoku obiektowym

CREATE OR REPLACE TYPE inventory_obj AS OBJECT (
   item_id          NUMBER (10),
   reorder_status   VARCHAR2 (20 CHAR),
   price            discount_price_obj,
   MEMBER PROCEDURE print_inventory,
   MEMBER PROCEDURE print_status,
   MEMBER PROCEDURE print_price
)
INSTANTIABLE NOT FINAL;
/

-- Tworzy widok inventory_vie

CREATE VIEW inventory_vie
   OF inventory_obj
   WITH OBJECT IDENTIFIER (item_id)
AS
   SELECT i.item_id, i.reorder_status, i.price
     FROM inventory_tbl i
/
INSERT INTO inventory_tbl
     VALUES (1, 10, 'DOSTEPNY', discount_price_obj (.1, 75));
INSERT INTO inventory_tbl
     VALUES (2, 13, 'DOSTEPNY', discount_price_obj (.1, 54.95));
INSERT INTO inventory_tbl
     VALUES (3, 24, 'DOSTEPNY', discount_price_obj (.15, 43.95));
INSERT INTO inventory_tbl
     VALUES (4, 13, 'DOSTEPNY', discount_price_obj (.1, 60));
INSERT INTO inventory_tbl
     VALUES (5, 5, 'DOSTEPNY', discount_price_obj (.20, 42.95));
COMMIT ;

PROMPT
PROMPT ** Pobieranie wszystkich rekordow z widoku obiektowego inventory_vie
PROMPT
SELECT *
  FROM inventory_vie
/
PROMPT
PROMPT ** Pobieranie kolumn z widoku, atrybutow z kolumny obiektowej
PROMPT **  i wywolanie metody discount_price
PROMPT
SELECT i.item_id, i.price.price, i.price.discount_rate,
       i.price.discount_price ()
  FROM inventory_vie i
/
-- Ponisza instrukcja SELECT nie bdzie dziaa dla widoku, cho
--  w tabeli istnieje podana kolumna

-- SELECT i.num_in_stock
-- FROM inventory_vie i;

CREATE OR REPLACE TRIGGER inventory_trg
   INSTEAD OF INSERT
   ON inventory_vie
   FOR EACH ROW
BEGIN
   INSERT INTO inventory_tbl
        VALUES (:NEW.item_id, NULL, :NEW.reorder_status, :NEW.price);
END;
/
INSERT INTO inventory_vie
     VALUES (6, 'ZAMOWIONY', discount_price_obj (.15, 64.95));

SELECT *
  FROM inventory_tbl
 WHERE item_id = 6;
