/*
 * ObjectTable.sql
 * Rozdzia 15, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje tworzenie tabeli obiektowej i
 *  obejmuje blok anonimowy, ktry ilustruje wykonywanie operacji DML
 *  na tabeli obiektowej
 */

exec clean_schema.synonyms
exec clean_schema.tables
exec clean_schema.objects

SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE TYPE discount_price_obj AS OBJECT (
   discount_rate   NUMBER (10, 4),
   price           NUMBER (10, 2),
   MEMBER FUNCTION discount_price
      RETURN NUMBER
)
INSTANTIABLE FINAL;
/

CREATE OR REPLACE TYPE BODY discount_price_obj
AS
   MEMBER FUNCTION discount_price
      RETURN NUMBER
   IS
   BEGIN
      RETURN (SELF.price * (1 - SELF.discount_rate));
   END discount_price;
END;
/

CREATE TABLE discount_price_tbl OF discount_price_obj;


DECLARE
   v_discount_rate    discount_price_tbl.discount_rate%TYPE;
   v_original_price   discount_price_tbl.price%TYPE;
   v_discount_price   discount_price_tbl.price%TYPE;
BEGIN
   -- Wstawianie nowego wiersza do tabeli discount_price_tbl
   INSERT INTO discount_price_tbl
        VALUES (.1, 54.95);

   -- Aktualizowanie rekordu poprzez zmian wysokoci rabatu
   UPDATE discount_price_tbl
      SET discount_rate = .15
    WHERE discount_rate = .1;

   -- Pobieranie i wywietlanie wartoci na ekranie
   SELECT discount_rate, price, price - (discount_rate * price)
     INTO v_discount_rate, v_original_price, v_discount_price
     FROM discount_price_tbl
     WHERE rownum < 2;

   DBMS_OUTPUT.put_line ('Cena wyjsciowa: ' || v_original_price);
   DBMS_OUTPUT.put_line (   'Zastosowany rabat: '
                         || v_discount_rate * 100
                         || '%'
                        );
   DBMS_OUTPUT.put_line ('Nasza bardzo, bardzo niska cena: ' || v_Discount_Price);

   -- Usuwanie dodanego wiersza
   DELETE FROM discount_price_tbl;
END;
/

INSERT INTO discount_price_tbl
     VALUES (.1, 54.95);
INSERT INTO discount_price_tbl
     VALUES (.1, 39.95);
INSERT INTO discount_price_tbl
     VALUES (.15, 42.95);
INSERT INTO discount_price_tbl
     VALUES (.2, 65.95);
INSERT INTO discount_price_tbl
     VALUES (.1, 52.95);

SELECT d.price "Cena wyjsciowa", d.discount_price () "Nasza cena"
  FROM discount_price_tbl d;


CREATE OR REPLACE TYPE inventory_obj AS OBJECT (
   item_id          NUMBER (10),
   num_in_stock     NUMBER (10),
   reorder_status   VARCHAR2 (20 CHAR),
   price            discount_price_obj,
   MEMBER PROCEDURE print_inventory,
   MEMBER PROCEDURE print_status,
   MEMBER PROCEDURE print_price
)
INSTANTIABLE NOT FINAL;
/

CREATE TABLE inventory_tbl OF inventory_obj;

INSERT INTO inventory_tbl
     VALUES (1, 10, 'DOSTEPNY', discount_price_obj (.1, 75));
