/*
 * objMaintain.sql
 * Rozdzia 15, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje ewolucj typw
 */

SET SERVEROUTPUT ON SIZE 1000000

exec clean_schema.synonyms
exec clean_schema.tables
exec clean_schema.objects

-- Typ address_obj znajduje si na kracu acucha, na ktrym nie wystpuj zalenoci

CREATE OR REPLACE TYPE address_obj AS OBJECT (
   address1   VARCHAR2 (30 CHAR),
   address2   VARCHAR2 (30 CHAR),
   city       VARCHAR2 (30 CHAR),
   state      CHAR (2 CHAR)
)
INSTANTIABLE FINAL;
/

-- person_obj take znajduje si na tym kracu

CREATE OR REPLACE TYPE person_obj AS OBJECT (
   first_name   VARCHAR2 (20),
   last_name    VARCHAR2 (20)
)
INSTANTIABLE FINAL;
/

-- contact_obj czy dwa pierwsze typy obiektowe
--   i ma jeszcze jeden atrybut

CREATE OR REPLACE TYPE contact_obj AS OBJECT (
   NAME      person_obj,
   address   address_obj,
   phone     NUMBER (10)
)
INSTANTIABLE FINAL;
/

-- W ostatnim typie znajduje si atrybut publisher_obj.contact_info,
--   ktrego typ danych to contact_obj

CREATE OR REPLACE TYPE publisher_obj AS OBJECT (
   pub_name       VARCHAR2 (30),
   contact_info   contact_obj,
   MEMBER PROCEDURE show_contact
)
INSTANTIABLE FINAL;
/

CREATE OR REPLACE TYPE BODY publisher_obj
AS
   MEMBER PROCEDURE show_contact
   IS
   BEGIN
      DBMS_OUTPUT.put_line ('DANE KONTAKTOWE');
      DBMS_OUTPUT.put_line ('===============');
      DBMS_OUTPUT.put_line (SELF.pub_name);
      DBMS_OUTPUT.put_line (   SELF.contact_info.NAME.first_name
                            || ' '
                            || SELF.contact_info.NAME.last_name
                           );
      DBMS_OUTPUT.put_line (SELF.contact_info.address.address1);
      DBMS_OUTPUT.put_line (SELF.contact_info.address.city);
      DBMS_OUTPUT.put_line (SELF.contact_info.address.state);
      DBMS_OUTPUT.put_line (SELF.contact_info.phone);
      RETURN;
   END show_contact;
END;
/

-- Tabela obiektowa bazujca na typie publisher_obj
CREATE TABLE publisher_tbl OF publisher_obj;

-- Kod do testowania
/*
* 
* DECLARE
*    v_person      person_obj    := person_obj ('Ron', 'Hardman');
*    v_address     address_obj
*                        := address_obj ('123 Ora Way', NULL, 'Colorado Springs', 'CO');
*    v_contact     contact_obj := contact_obj (v_person, v_address, 5555555555);
*    v_publisher   publisher_obj := publisher_obj ('Oracle Press', v_contact);
* BEGIN
*   v_publisher.show_contact;
* END;
* /
* 
*/


/*
 * SEKCJA 2: Ten fragment demonstruje dziedziczenie
 */

PROMPT
PROMPT *** Tworzenie typu discount_price_obj ***
PROMPT
PROMPT *** Discount_price_obj to typ danych atrybutu price
PROMPT *** typu obiektowego inventory_obj
PROMPT

-- Specyfikacja typu discount_price_obj

CREATE OR REPLACE TYPE discount_price_obj AS OBJECT (
   discount_rate   NUMBER (10, 4),
   price           NUMBER (10, 2),
   MEMBER FUNCTION discount_price
      RETURN NUMBER
)
INSTANTIABLE FINAL;
/

CREATE OR REPLACE TYPE BODY discount_price_obj
AS
   MEMBER FUNCTION discount_price
      RETURN NUMBER
   IS
   BEGIN
      RETURN (SELF.price * (1 - SELF.discount_rate));
   END discount_price;
END;
/

/*******************************************************
* 
* Poniszy kod suy do testowania typu discount_price_obj
*
* DECLARE
*    v_price discount_price_obj := discount_price_obj(.1, 75.00);
* BEGIN
*    dbms_output.put_line(v_price.discount_price);
* END;
* /
* 
*******************************************************/


PROMPT *** Tworzenie typu inventory_obj ***
PROMPT
PROMPT *** inventory_obj to zozony typ obiektowy, ktory uzywa
PROMPT *** typu discount_price_obj jako typu danych
PROMPT *** atrybutu price.  Jest on bazowym typem obiektowym,
PROMPT *** ktry umozliwia tworzenie obiektw
PROMPT

-- Specyfikacja typu inventory_obj

CREATE OR REPLACE TYPE inventory_obj AS OBJECT (
   item_id          NUMBER (10),
   num_in_stock     NUMBER (10),
   reorder_status   VARCHAR2 (20 CHAR),
   price            NUMBER (10, 2),
   CONSTRUCTOR FUNCTION inventory_obj (
      item_id        IN   NUMBER,
      num_in_stock   IN   NUMBER,
      price          IN   NUMBER
   )
      RETURN SELF AS RESULT,
   MEMBER PROCEDURE print_inventory,
   MEMBER PROCEDURE print_status,
   MEMBER PROCEDURE print_price
)
INSTANTIABLE NOT FINAL;
/

CREATE OR REPLACE TYPE BODY inventory_obj
AS
   CONSTRUCTOR FUNCTION inventory_obj (
      item_id        IN   NUMBER,
      num_in_stock   IN   NUMBER,
      price          IN   NUMBER
   )
      RETURN SELF AS RESULT
   IS
   BEGIN
      SELF.item_id := item_id;
      SELF.num_in_stock := num_in_stock;
      SELF.price := price;
      RETURN;
   END;
   MEMBER PROCEDURE print_inventory
   IS
   BEGIN
      DBMS_OUTPUT.put_line ('ASORTYMENT KSIEGARNI1');
      DBMS_OUTPUT.put_line ('=====================');
      DBMS_OUTPUT.put_line (   'Liczba artykulow o numerze '
                            || SELF.item_id
                            || ' to '
                            || SELF.num_in_stock
                            || ' .');
   END print_inventory;
   MEMBER PROCEDURE print_status
   IS
      v_status   VARCHAR2 (20);
   BEGIN
      IF SELF.num_in_stock > 0
      THEN
         v_status := 'DOSTEPNY';
      ELSE
         v_status := 'NIEDOSTEPNY';
      END IF;

      DBMS_OUTPUT.put_line ('STAN MAGAZYNU KSIEGARNI1');
      DBMS_OUTPUT.put_line ('========================');
      DBMS_OUTPUT.put_line ('Produkt o numerze ' || SELF.item_id || ' jest '
                            || v_status
                           );
   END print_status;
   MEMBER PROCEDURE print_price
   IS
      v_discount_price   discount_price_obj
                                       := discount_price_obj (.1, SELF.price);
   BEGIN
      DBMS_OUTPUT.put_line ('CENY W KSIEGARNI1');
      DBMS_OUTPUT.put_line ('=================');
      DBMS_OUTPUT.put_line ('Produkt o numerze ' || SELF.item_id);
      DBMS_OUTPUT.put_line ('Cena detaliczna: ' || SELF.price || ' zlotych');
      DBMS_OUTPUT.put_line (   'NASZA BARDZO - BARDZO - NISKA CENA: '
                            || v_discount_price.price
                            || ' zlotych'
                           );
   END print_price;
END;
/

-- Uyj tego kodu do przetestowania obiektu inventory_obj
/*
*
* DECLARE
*    v_inventory   inventory_obj := inventory_obj (3124, 15, 39.99);
* BEGIN
*    v_inventory.print_inventory;
*    DBMS_OUTPUT.put_line ('	');
*    v_inventory.print_status;
*    DBMS_OUTPUT.put_line ('	');
*    v_inventory.print_price;
* END;
* /
* 
*/

PROMPT *** Tworzenie typu book_obj ***
PROMPT
PROMPT *** Book_obj to typ pochodny od inventory_obj
PROMPT

CREATE OR REPLACE TYPE book_obj
UNDER inventory_obj (
   isbn        CHAR (10 CHAR),
   CATEGORY    VARCHAR2 (20 CHAR),
   title       VARCHAR2 (100 CHAR),
   num_pages   NUMBER,
   publisher   publisher_obj,
   CONSTRUCTOR FUNCTION book_obj (
      item_id        NUMBER,
      num_in_stock   NUMBER,
      price          NUMBER,
      isbn           CHAR,
      title          VARCHAR2,
      num_pages      NUMBER
   )
      RETURN SELF AS RESULT,
   MEMBER PROCEDURE print_book_information,
   OVERRIDING MEMBER PROCEDURE print_price
)
INSTANTIABLE NOT FINAL;
/

CREATE OR REPLACE TYPE BODY book_obj
IS
   CONSTRUCTOR FUNCTION book_obj (
      item_id        NUMBER,
      num_in_stock   NUMBER,
      price          NUMBER,
      isbn           CHAR,
      title          VARCHAR2,
      num_pages      NUMBER
   )
      RETURN SELF AS RESULT
   IS
   BEGIN
      SELF.item_id := item_id;
      SELF.num_in_stock := num_in_stock;
      SELF.price := price;
      SELF.isbn := isbn;
      SELF.title := title;
      SELF.num_pages := num_pages;
      RETURN;
   END book_obj;
   MEMBER PROCEDURE print_book_information
   IS
   BEGIN
      DBMS_OUTPUT.put_line ('INFORMACJE O KSIAZCE');
      DBMS_OUTPUT.put_line ('====================');
      DBMS_OUTPUT.put_line ('Tytul: '
                            || SELF.title);
      DBMS_OUTPUT.put_line ('Liczba stron: ' 
                            || SELF.num_pages);
      DBMS_OUTPUT.put_line ('Na stanie: ' 
                            || SELF.num_in_stock);
   END print_book_information;
   OVERRIDING MEMBER PROCEDURE print_price
   IS
   BEGIN
      DBMS_OUTPUT.put_line ('CENY W KSIEGARNI1');
      DBMS_OUTPUT.put_line ('================');
      DBMS_OUTPUT.put_line ('Tytul: '
                            || SELF.title);
      DBMS_OUTPUT.put_line ('Zawsze niska cena: ' 
                            || SELF.price);
   END print_price;
END;
/

-- Uyj tego kodu do przetestowania typu book_obj
/*
*
* DECLARE
*    v_book book_obj := book_obj (3124, 15, 39.99, '72121203', 'Oracle DBA 101', 563);
* BEGIN
*    v_book.print_book_information;
*    DBMS_OUTPUT.put_line ('	');
*    v_book.print_price;
* END;
* /
*
*/

CREATE OR REPLACE TYPE music_person_obj AS OBJECT (
   first_name   VARCHAR2 (50 CHAR),
   last_name    VARCHAR2 (50 CHAR)
)
FINAL INSTANTIABLE;
/

CREATE OR REPLACE TYPE music_obj
UNDER inventory_obj (
   style      VARCHAR2 (50 CHAR),
   composer   music_person_obj,
   artist     music_person_obj
)
NOT FINAL INSTANTIABLE;
/

CREATE OR REPLACE TYPE cd_obj
UNDER music_obj (
   title           VARCHAR2 (50 CHAR),
   date_released   DATE,
   CONSTRUCTOR FUNCTION cd_obj (
      artist          music_person_obj,
      title           VARCHAR2,
      date_released   DATE
   )
      RETURN SELF AS RESULT,
   MEMBER PROCEDURE show_cd
)
FINAL INSTANTIABLE;
/

CREATE OR REPLACE TYPE BODY cd_obj
AS
   CONSTRUCTOR FUNCTION cd_obj (
      artist          music_person_obj,
      title           VARCHAR2,
      date_released   DATE
   )
      RETURN SELF AS RESULT
   IS
   BEGIN
      SELF.artist := artist;
      SELF.title := title;
      SELF.date_released := date_released;
      RETURN;
   END cd_obj;
   MEMBER PROCEDURE show_cd
   IS
   BEGIN
      DBMS_OUTPUT.put_line ('TYTULY PLYT W KSIEGARNI1');
      DBMS_OUTPUT.put_line ('==========================');
      DBMS_OUTPUT.put_line ('TYTUL: ' || SELF.title);
      DBMS_OUTPUT.put_line (   'WYKONAWCA: '
                            || SELF.artist.first_name
                            || ' '
                            || SELF.artist.last_name
                           );
      DBMS_OUTPUT.put_line ('DATA WYDANIA: ' || SELF.date_released);
   END show_cd;
END;
/

/*
 *
 * Teraz tworzone s egzemplarze typw obiektowych. Kod tworzy
 *  trwae obiekty, wczajc w to tabel obiektow i widok obiektowy
 *
 */

CREATE TABLE book_tbl OF book_obj;

INSERT INTO book_tbl
     VALUES (2, 13, 'DOSTEPNY', 54.95, '72121203', 'TECHNICAL',
             'Oracle DBA 101', 563,
             publisher_obj ('Oracle Press',
                            contact_obj (person_obj ('Zuzanna', 'Wydawca'),
                                         address_obj ('Prosta 10',
                                                      '2',
                                                      'Moje Miasto',
                                                      'MAZ'
                                                     ),
                                         '5555555555'
                                        )
                           ));

/*
 *
 * Tworzenie widoku book_vie
 *
 */

CREATE VIEW book_vie
   OF book_obj
   WITH OBJECT IDENTIFIER (item_id)
AS
   SELECT item_id, num_in_stock, reorder_status, price, isbn, CATEGORY, title,
          num_pages, publisher
     FROM book_tbl;

/*
 *
 * Testowanie utworzonego widoku za pomoc prostej instrukcji SELECT
 *
 */

SELECT b.item_id, b.reorder_status, b.price,
       b.publisher.contact_info.NAME.first_name
  FROM book_vie b;

/*
 *
 * Wywietlanie informacji o widoku
 *
 */
SET DESC DEPTH ALL
DESC book_vie

/*
 *
 * Prba prostej zmiany w postaci dodania atrybutu do typu inventory_obj w tym miejscu
 *  wymaga zastosowania modyfikatora CASCADE
 *
 * SQL> ALTER TYPE inventory_obj
 *   2  ADD ATTRIBUTE location VARCHAR2(100 CHAR);
 *  ALTER TYPE inventory_obj
 *
 *  ERROR at line 1:
 *  ORA-22312: must specify either CASCADE or INVALIDATE option
 *
 */

/*
 *
 * Modyfikacja typu obiektowego inventory_obj przy uyciu modyfikatora CASCADE.
 *
 */

ALTER TYPE inventory_obj
  ADD ATTRIBUTE LOCATION VARCHAR2(100 CHAR) CASCADE;


/*
 *
 * Wywietlanie informacji o typie book_obj, tabeli book_tbl i widoku book_vie
 *
 */

PROMPT
PROMPT
PROMPT Instrukcja DESC book_obj moze wywolac blad (zalezy to od pamieci podrecznej)
PROMPT ============================================================================
DESC book_obj

PROMPT
PROMPT Instrukcja DESC book_table wyswietla strukture tabeli
PROMPT =====================================================
DESC book_tbl

PROMPT 
PROMPT Instrukcja DESC book_vie nie powiedzie sie z powodu zmian w typie book_obj
PROMPT ==========================================================================
DESC book_vie