/*
 * ForwardDeclaration.sql
 * Rozdzia 15, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uprzedzajce deklaracje typw
 */

SET SERVEROUTPUT ON SIZE 1000000 ECHO OFF

exec clean_schema.synonyms
exec clean_schema.tables
exec clean_schema.objects

PROMPT
PROMPT Proba utworzenia typu inventory_obj powoduje ponizszy wyjatek:
PROMPT ==============================================================

CREATE OR REPLACE TYPE inventory_obj AS OBJECT (
   item_id        NUMBER(10),
   num_in_stock   NUMBER(10), 
   reorder_status VARCHAR2(20),
   price       REF   discount_price_obj);
/

SHOW ERRORS

PROMPT
PROMPT Aby uniknac tego problemu, nalezy uzyc deklaracji uprzedzajacej typu discount_price_obj
PROMPT =======================================================================================

CREATE TYPE discount_price_obj;
/

PROMPT
PROMPT Teraz mozna utworzyc typ inventory_obj
PROMPT ======================================

CREATE OR REPLACE TYPE inventory_obj AS OBJECT (
   item_id        NUMBER(10),
   num_in_stock   NUMBER(10), 
   reorder_status VARCHAR2(20),
   price       REF   discount_price_obj);
/