/*
 * TypeAttribute.sql
 * Rozdzia 14, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje zastosowanie atrybutu %TYPE
 */

exec clean_schema.synonyms
exec clean_schema.tables
exec clean_schema.objects

CREATE OR REPLACE TYPE discount_price_obj AS OBJECT (
   discount_rate   NUMBER (10, 4),
   price           NUMBER (10, 2),
   CONSTRUCTOR FUNCTION discount_price_obj (price NUMBER)
      RETURN SELF AS RESULT
)
INSTANTIABLE FINAL;
/

CREATE OR REPLACE TYPE BODY discount_price_obj
AS
   CONSTRUCTOR FUNCTION discount_price_obj (price NUMBER)
      RETURN SELF AS RESULT
   AS
   BEGIN
      SELF.price := price * .9;
      RETURN;
   END discount_price_obj;
END;
/

prompt
prompt Ten fragment dziala poprawnie. Wartosc %TYPE jest zastosowana do
prompt   zmiennej, a nie bezposrednio do typu obiektowego.
prompt

DECLARE
   v_discount_price   discount_price_obj;
   v_price           v_discount_price.price%TYPE;
BEGIN
   NULL;
END;
/

prompt
prompt Ten kod zglosi wyjatek. Wartosc %TYPE jest tu zastosowana do
prompt   bezposrednio do typu obiektowego.
prompt

DECLARE
   v_price           discount_price_obj.price%TYPE;
BEGIN
   NULL;
END;
/
