/*
 * nds_sql_01.sql
 * Rozdzia 13, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Cel:
 *   Suy do testowania NDS
 */

-- Blok testowy tworzcy, zwikszajcy i usuwajcy sekwencj
DECLARE

  -- Definicje zmiennych lokalnych
  value_in          VARCHAR2(30) := 'TESTING_S1';
  value_out         NUMBER;

BEGIN

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

  -- Test procedury create_sequence
  nds_tutorial.create_sequence(value_in);

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

  -- Uycie ptli for do trzykrotnego zwikszenia sekwencji
  FOR i IN 1..3 LOOP

    -- Zwikszanie sekwencji
    nds_tutorial.increment_sequence(value_in,value_out);

  -- Wiersz rozdzielajcy
    dbms_output.put_line(nds_tutorial.sline);

  END LOOP;

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

  -- Usuwanie sekwencji
  nds_tutorial.drop_sequence(value_in);

  -- Wiersz rozdzielajcy
  dbms_output.put_line(nds_tutorial.dline);

END;
/
