/*
 * dbms_sql_03.sql
 * Rozdzia 13, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Cel:
 *   Suy do testowania pakietu DBMS_SQL_TUTORIAL
 */

-- Definicje zmiennych lokalnych na potrzeby DBMS_SQL
VARIABLE table_name   VARCHAR2(30)
VARIABLE column_name1 VARCHAR2(30)
VARIABLE column_name2 VARCHAR2(30)
VARIABLE column_name3 VARCHAR2(30)

-- Blok testowy tworzcy, zwikszajcy i usuwajcy tabel
DECLARE

  -- Definicje tabeli zagniedonych
  TYPE card_number_table IS TABLE OF NUMBER
                            INDEX BY BINARY_INTEGER;
  TYPE card_name_table   IS TABLE OF VARCHAR2(2000)
                            INDEX BY BINARY_INTEGER;
  TYPE card_suit_table   IS TABLE OF VARCHAR2(2000)
                            INDEX BY BINARY_INTEGER;

  -- Deklaracja i inicjowanie tabeli zagniedonej o trzech wierszach
  card_numbers CARD_NUMBER_TABLE;
  card_names   CARD_NAME_TABLE;
  card_suits   CARD_SUIT_TABLE;

  -- Definicje zmiennych lokalnych
  column_name1          VARCHAR2(30) := 'CARD_NUMBER';
  column_name2          VARCHAR2(30) := 'CARD_NAME';
  column_name3          VARCHAR2(30) := 'CARD_SUIT';
  table_name_in         VARCHAR2(30)   := 'CARD_DECK';
  table_definition_in   VARCHAR2(2000);
  table_column_value1   DBMS_SQL.NUMBER_TABLE;
  table_column_value2   DBMS_SQL.VARCHAR2_TABLE;
  table_column_value3   DBMS_SQL.VARCHAR2_TABLE;

BEGIN

  -- Przypisanie nazwy tabeli do zmiennej powizanej
  :table_name   := table_name_in;
  :column_name1 := column_name1;
  :column_name2 := column_name2;
  :column_name3 := column_name3;

  -- Inicjowanie numerw kart
  FOR i IN 1..13 LOOP
    card_numbers(i) := i;
  END LOOP;

  -- Inicjowanie nazw kart
  card_names(1)  := 'As';
  card_names(2)  := 'Dwojka';
  card_names(3)  := 'Trojka';
  card_names(4)  := 'Czworka';
  card_names(5)  := 'Piatka';
  card_names(6)  := 'Szostka';
  card_names(7)  := 'Siodemka';
  card_names(8)  := 'Osemka';
  card_names(9)  := 'Dziewiatka';
  card_names(10) := 'Dziesiatka';
  card_names(11) := 'Walet';
  card_names(12) := 'Dama';
  card_names(13) := 'Krol';

  -- Inicjowanie kolorw kart
  card_suits(1)  := 'Pik';
  card_suits(2)  := 'Kier';
  card_suits(3)  := 'Karo';
  card_suits(4)  := 'Trefl';
  card_suits(5)  := 'Pik';
  card_suits(6)  := 'Kier';
  card_suits(7)  := 'Karo';
  card_suits(8)  := 'Trefl';
  card_suits(9)  := 'Pik';
  card_suits(10) := 'Kier';
  card_suits(11) := 'Karo';
  card_suits(12) := 'Trefl';
  card_suits(13) := 'Pik';

  -- Przypisanie w ptli numerw kart
  FOR i IN CARD_NUMBERS.FIRST..CARD_NUMBERS.LAST LOOP
    table_column_value1(i) := card_numbers(i);
  END LOOP;

  -- Przypisanie w ptli nazw kart
  FOR i IN CARD_NAMES.FIRST..CARD_NAMES.LAST LOOP
    table_column_value2(i) := card_names(i);
  END LOOP;

  -- Przypisanie w ptli kolorw  kart
  FOR i IN CARD_SUITS.FIRST..CARD_SUITS.LAST LOOP
    table_column_value3(i) := card_suits(i);
  END LOOP;

  -- Inicjowanie definicji tabeli
  table_definition_in := '('||column_name1||' NUMBER'        ||CHR(10)
                      || ','||column_name2||' VARCHAR2(2000)'||CHR(10)
                      || ','||column_name3||' VARCHAR2(2000))';

  -- Wywietlanie danych wyjciowych
  dbms_output.put_line(dbms_sql_tutorial.dline);
  dbms_sql_tutorial.create_table(table_name_in,table_definition_in);

  -- Wstawianie danych do tabeli
  dbms_output.put_line(dbms_sql_tutorial.dline);
  dbms_sql_tutorial.inserts_into_table( table_name_in
                                      , table_column_value1
                                      , table_column_value2
                                      , table_column_value3);
  dbms_output.put_line(dbms_sql_tutorial.dline);

END;
/

-- Ustawienie formatowania rodowiska SQL*Plus
COL c1   FORMAT 999      HEADING "Test|Komunikat|ID #"
COL c2   FORMAT A20      HEADING "Wyslany komunikat"
COL c3   FORMAT A30      HEADING "Odbiorca"

-- Pobieranie danych z dynamicznie utworzonej tabeli
SELECT   card_number c1
,        card_name c2
,        card_suit c3
FROM     card_deck;

-- Uycie pakietu DBMS_SQL_TUTORIAL do usunicia tabeli
BEGIN

  -- Uruchomienie dynamicznego polecenia DQL na tabeli
  dbms_output.put_line(dbms_sql_tutorial.dline);
  dbms_sql_tutorial.multiple_row_return(:table_name
                                       ,:column_name1
                                       ,:column_name2
                                       ,:column_name3);
  dbms_output.put_line(dbms_sql_tutorial.dline);

  -- Usunicie tabeli
  dbms_output.put_line(dbms_sql_tutorial.dline);
  dbms_sql_tutorial.drop_table(:table_name);
  dbms_output.put_line(dbms_sql_tutorial.dline);

END;
/
