/*
 * dbms_sql_01.sql
 * Rozdzia 13, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Cel:
 *   Suy do testowania pakietu DBMS_SQL_TUTORIAL
 */

-- Blok testowy tworzcy, zwikszajcy i usuwajcy sekwencj
DECLARE

  -- Definicje zmiennych lokalnych
  value_in          VARCHAR2(30) := 'TESTING_S1';
  value_out         NUMBER;

BEGIN

  -- Wiersz rozdzielajcy
  dbms_output.put_line(dbms_sql_tutorial.dline);

  -- Test procedury create_sequence
  dbms_sql_tutorial.create_sequence(value_in);

  -- Wiersz rozdzielajcy
  dbms_output.put_line(dbms_sql_tutorial.dline);

  -- Trzykrotne uruchomienie ptli
  FOR i IN 1..3 LOOP

    -- Test procedury increment_sequence
    dbms_sql_tutorial.increment_sequence(value_in,value_out);

  END LOOP;

  -- Wiersz rozdzielajcy
  dbms_output.put_line(dbms_sql_tutorial.dline);

  -- Usunicie sekwencji
  dbms_sql_tutorial.drop_sequence(value_in);

  -- Wiersz rozdzielajcy
  dbms_output.put_line(dbms_sql_tutorial.dline);

END;
/
