/*
 * ReadFile1.java
 * Rozdzia 12, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt pokazuje, jak wczyta plik przy uyciu jzyka Java.
 * Skrypt jest zaprojektowany jako plik biblioteczny w jzyku Java dla
 * skadowanej biblioteki bazy danych Oracle
 */

// Importowanie klasy
import java.io.*;

// Definicja klasy
public class ReadFile1
{
  // Definicja metody readString() przyjmujcej warto typu String 
  public static String readString(String s)
  {
    // Wywoanie metody readString() z argumentem typu File
    return readFileString(new File(s));
  }

  // Definicja metody readFileString()przyjmujcej warto typu File 
  private static String readFileString(File file)
  {
    // Definicja zmiennej typu int do wczytywania pliku
    int c;

    // Definicja obiektu typu String na zwracany tekst
    String s = new String();

    // Definicja obiektu typu FileReader
    FileReader inFile;

    // Uycie bloku try-catch, poniewa wymaga tego typ FileReader 
    try
    {
      // Przypisanie pliku
      inFile = new FileReader(file);

      // Wczytywanie po jednym znaku
      while ((c = inFile.read()) != -1)
      {
        // Doczenie znaku do acucha
        s += (char) c;

      } // Koniec ptli while 

    } // Koniec bloku try 
    catch (IOException e)
    {
      // Zwrcenie bdu
      return e.getMessage();

    } // Koniec bloku catch 

    // Zwracanie acucha znakw 
    return s;

  } // Koniec metody readFileString()

  // Definicja metody main()
  public static void main(String[] args)
  {
    // Definicja nazwy pliku
    String file = new String("/tmp/file.txt");

    // Wywietlanie acucha znakw
    System.out.println(ReadFile1.readString(file));

  } // Koniec metody main() 

} // Koniec klasy ReadFile

