/*
 * write_pipe.sql
 * Rozdzia 11, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt zapisuje trzy komunikaty do prywatnych i publicznych
 * potokw, uywajc pakietu DBMS_PIPE
 *
 * - Ten kod wymaga wywoania skrytpu create_pipe2.sql, ktry
 *   jest wywoywany przed uruchomieniem poniszego bloku anonimowego PL/SQL
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Gwarantowanie utworzenia potoku publicznego
@create_pipe2.sql

-- Demonstruje wysyanie komunikatw
DECLARE

  -- Definicja przeamania wiersza sucego do rozdzielania zapisw danych w potoku
  line_return VARCHAR2(1) := CHR(10);

  -- Definicja zmiennej na zwracan warto
  flag        INTEGER;

BEGIN

  -- Usuwanie zawartoci potoku
  dbms_pipe.purge('PLSQL$MESSAGE_INBOX');

  -- Wywietlanie nagwka danych wejciowych
  DBMS_OUTPUT.PUT_LINE('Komunikaty wejsciowe potoku');
  DBMS_OUTPUT.PUT_LINE('---------------------------');

  -- Ptla for bazujca na przedziale wysya trzy komunikaty 
  FOR i IN 1..3 LOOP

    -- Wywietla wiersz danych wejciowych
    DBMS_OUTPUT.PUT_LINE('Komunikat ['||i||']');

    -- Odpowiednia procedura umieszcza komunikat w buforze lokalnym 
    DBMS_PIPE.PACK_MESSAGE('Komunikat ['||i||']'||line_return);

    -- Wysyanie komunikatu; zwrcenie wartoci zero oznacza powodzenie
    flag := DBMS_PIPE.SEND_MESSAGE('PLSQL$MESSAGE_INBOX');

  END LOOP;

  -- Wywietlenie komunikatu na podstawie wartoci zmiennej flag
  IF (flag = 0) THEN
    DBMS_OUTPUT.PUT_LINE('Przeslano komunikat do PLSQL$MESSAGE_INBOX.');
  END IF;

END;
/
