/*
 * write_local.sql
 * Rozdzia 11, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt uywa pakietu DBMS_PIPE do zapisu lokalnego komunikatu
 * do niejawnego anonimowego potoku sesji. Ten potok ma nastpujce
 * cechy:
 *
 * - Dostp do niego maj uytkownicy z uprawnieniami EXECUTE do
 *   pakietu DBMS_PIPE
 * - Jest tworzony w obszarze SGA jako potok prywatny powizany z
 *   nazw sesji UNIQUE_SESSION_NAME
 * - Jest tworzony automatycznie poprzez wywoanie w sesji
 *   procedury DBMS_PIPE.PACK_MESSAGE
 * - Jest anonimowy pod tym wzgldem, e nie mona
 *   sprawdzi jego nazwy, ani adresu na podstawie nazwy
 * - Do usuwania zawartoci anonimowych potokw lokalnych suy
 *   procedura DBMS_PIPE.RESET_BUFFER
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Definicja bloku anonimowego zapeniajcego lokalny potok prywatny
DECLARE

  -- Definiowanie zmiennych na potrzeby funkcji i procedur
  message   VARCHAR2(30 CHAR);
  success   INTEGER;

BEGIN

  -- Przypisywanie niepowtarzalnej nazwy sesji do komunikatu
  message := DBMS_PIPE.UNIQUE_SESSION_NAME;

  -- Zerowanie prywatnego potoku lokalnego
  DBMS_PIPE.RESET_BUFFER;

  -- Zapis komunikatu do prywatnego potoku lokalnego
  DBMS_PIPE.PACK_MESSAGE(message);

  -- Wywietlanie danych zapisanych do potoku
  DBMS_OUTPUT.PUT_LINE('Zapisano do potoku ['||message||']');

END;
/
