/*
 * read_pipe.sql
 * Rozdzia 11, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt odczytuje trzy komunikaty z prywatnych i publicznych
 * potokw, uywajc pakietu DBMS_PIPE
 *
 * - Ten kod wymaga wywoania skrytpu create_pipe2.sql, ktry
 *   jest wywoywany przed uruchomieniem poniszego bloku anonimowego PL/SQL
 * - Ten kod wymaga wywoania skrytpu write_pipe.sql, ktry
 *   jest wywoywany przed uruchomieniem poniszego bloku anonimowego PL/SQL
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Gwarantowanie utworzenia potoku publicznego
@create_pipe2.sql
@write_pipe.sql

-- Demonstruje pobieranie komunikatw
DECLARE

  -- Definicja zmiennej message
  line_return VARCHAR2(1)     := CHR(10);
  message     VARCHAR2(4000);
  output      VARCHAR2(4000);

  -- Definicja zmiennej na zwracan warto
  flag        INTEGER;

BEGIN

  -- Wywietlanie nagwka
  DBMS_OUTPUT.PUT(line_return);
  DBMS_OUTPUT.PUT_LINE('Komunikat wyjsciowy potoku');
  DBMS_OUTPUT.PUT_LINE('--------------------------');

  -- Ptla for bazujca na przedziale suy do pobrania i odczytania trzech komunikatw
  FOR i IN 1..3 LOOP

    -- Zerowanie bufora lokalnego
    DBMS_PIPE.RESET_BUFFER;

    -- Pobieranie komunikatu; warto zero oznacza powodzenie
    flag := 
      DBMS_PIPE.RECEIVE_MESSAGE('PLSQL$MESSAGE_INBOX',0);

    -- Wczytanie komunikatu z bufora lokalnego
    DBMS_PIPE.UNPACK_MESSAGE(message);

    -- Doczenie komunikatu do zmiennej output
    output := output || message;

  END LOOP;

  -- Wywietla komunikat na podstawie wartoci zmiennej flag
  IF (flag = 0) THEN

    -- Wywietla zmienn output
    DBMS_OUTPUT.PUT(output);

    -- Wywietla komunikat potwierdzajcy pobranie danych
    DBMS_OUTPUT.PUT_LINE(
      'Pobrano komunikat z PLSQL$MESSAGE_INBOX.');
  END IF;

END;
/
