/*
 * read_local.sql
 * Rozdzia 11, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt uywa pakietu DBMS_PIPE do zapisu lokalnego komunikatu
 * do niejawnego anonimowego potoku sesji. Ten potok ma nastpujce
 * cechy:
 *
 * - Dostp do niego maj uytkownicy z uprawnieniami EXECUTE do
 *   pakietu DBMS_PIPE
 * - Jego odczyt odbywa si automatycznie w wyniku wywoania
 *   procedury DBMS_PIPE.UNPACK_MESSAGE w sesji
 * - Jest anonimowy pod tym wzgldem, e nie mona
 *   sprawdzi jego nazwy, ani adresu na podstawie nazwy
 * - Do usuwania zawartoci anonimowych potokw lokalnych suy
 *   procedura DBMS_PIPE.RESET_BUFFER
 * - Jeli nie wywoae wczeniej skryptu write_local.sql, ten
 *   program moe wywoa bd. Trzeba go uruchomi z tego samego
 *   katalogu, co write_local.sql
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Definicja bloku anonimowego wczytujcego dane z potoku prywatnego
DECLARE

  -- Definicje zmiennych na potrzeby funkcji i procedur
  message   VARCHAR2(30 CHAR);
  success   INTEGER;

BEGIN

  -- Wczytuje komunikat z prywatnego potoku lokalnego
  DBMS_PIPE.UNPACK_MESSAGE(message);

  -- Wywietla zawarto komunikatu 
  DBMS_OUTPUT.PUT_LINE('Komunikat ['||message||']');

END;
/
