/*
 * create_pipe4.sql
 * Rozdzia 11, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt usuwa potok, jeli jaki istnieje w kontekcie
 * biecej sesji, tworzy go ponownie, wysya komunikat i pobiera go z potoku
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Blok anonimowy usuwajcy potok
DECLARE

  -- Definicja i deklaracja zmiennej przy uyciu operacji usuwania potoku
  retval INTEGER := DBMS_PIPE.REMOVE_PIPE('MESSAGE_INBOX');
  retval INTEGER := DBMS_PIPE.REMOVE_PIPE('MESSAGE_OUTBOX');

BEGIN

 NULL; 

END;
/

-- Blok anonimowy tworzcy potok
DECLARE

  -- Definicja i deklaracja zmiennych
  message_pipe_in   VARCHAR2(30) := 'MESSAGE_INBOX';
  message_pipe_out  VARCHAR2(30) := 'MESSAGE_OUTBOX';
  message_size      INTEGER      := 20000;
  message_flag      BOOLEAN      := FALSE;
   
  -- Zmienna wyjciowa funkcji
  retval INTEGER;

  -- Definicja zmiennej wyjciowej
  output VARCHAR2(4000 CHAR);

  -- Niestandardowe wyjtku
  pipename_is_null  EXCEPTION;
  message_not_sized EXCEPTION;

  -- Definicja instrukcji prekompilatora na potrzeby niestandardowych wyjtkw
  PRAGMA EXCEPTION_INIT(pipename_is_null,-23321);
  PRAGMA EXCEPTION_INIT(message_not_sized,-6557);

  PROCEDURE print_status
    (pipename   VARCHAR2
    ,pipesize   INTEGER
    ,private    BOOLEAN DEFAULT TRUE
    ,value_in   INTEGER) IS
    
    -- Definicja acucha znakw o zmiennej dugoci na warto logiczn
    state       VARCHAR2(5 CHAR) := 'True';

  BEGIN

    -- Sprawdzanie wartoci logicznej i zmiana jej, jeli jest rna od wartoci domylnej
    IF NOT private THEN
      state := 'False';
    END IF;

    -- Wywietlanie stanu
    IF (value_in = 0) THEN
      DBMS_OUTPUT.PUT_LINE('Utworzono z powodzeniem');
      DBMS_OUTPUT.PUT_LINE('Nazwa potoku ['||pipename||']');
      DBMS_OUTPUT.PUT_LINE('Rozmiar potoku ['||pipesize||']');
      DBMS_OUTPUT.PUT_LINE('Prywatny   ['||state   ||']');
      DBMS_OUTPUT.PUT(CHR(10));
    END IF;

  END print_status;

BEGIN

  -- Definicja potoku prywatnego na komunikaty przychodzce
  retval := DBMS_PIPE.CREATE_PIPE(pipename    => message_pipe_in
                                 ,maxpipesize => message_size
                                 ,private     => message_flag);

  -- Wywietlanie wartoci wyjciowej
  print_status(message_pipe_in
              ,message_size
              ,message_flag
              ,retval);

  -- Definicja potoku prywatnego na komunikaty wychodzce
  retval := DBMS_PIPE.CREATE_PIPE
              (pipename    => message_pipe_out
              ,maxpipesize => message_size
              ,private     => message_flag);

  -- Wywietlanie wartoci wyjciowej
  print_status(message_pipe_out
              ,message_size
              ,message_flag
              ,retval);

  -- Wywietlanie stanu
  IF (retval = 0) THEN
    DBMS_OUTPUT.PUT(output);
  END IF;

EXCEPTION

  -- Zgaszany, jeli PIPENAME to null
  WHEN pipename_is_null THEN
    DBMS_OUTPUT.PUT_LINE('Nie zdefiniowano nazwy potoku');
    DBMS_OUTPUT.PUT_LINE(SQLERRM);
    RETURN;

  -- Zgaszany, jeli MAXPIPESIZE to null
  WHEN message_not_sized THEN
    DBMS_OUTPUT.PUT_LINE('Maksymalny rozmiar musi byc rozny od null');
    DBMS_OUTPUT.PUT_LINE(SQLERRM);
    RETURN;

  -- Zgaszanie oglnego wyjtku
  WHEN others THEN
    DBMS_OUTPUT.PUT_LINE('Inny blad');
    DBMS_OUTPUT.PUT_LINE(SQLERRM);
    RETURN;

END;
/    

