/*
 * create_pipe1.sql
 * Rozdzia 11, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt usuwa potok, jeli jaki istnieje w kontekcie
 * biecej sesji, a nastpnie tworzy go ponownie
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Blok anonimowy usuwajcy potok
DECLARE

  -- Definicja i deklaracja zmiennej przy uyciu operacji usuwania potoku
  retval INTEGER := DBMS_PIPE.REMOVE_PIPE('PLSQL$MESSAGE_INBOX');

BEGIN

 NULL; 

END;
/

-- Blok anonimowy tworzcy potok
DECLARE

  -- Definicja i deklaracja zmiennych
  message_pipe VARCHAR2(30) := 'PLSQL$MESSAGE_INBOX';
  message_size INTEGER      := 20000;
   
  -- Zmienna wyjciowa funkcji
  retval INTEGER;

BEGIN

  -- Definicja potoku prywatnego
  retval := DBMS_PIPE.CREATE_PIPE(message_pipe
                                 ,message_size);

  -- Wywietla stan operacji
  IF (retval = 0) THEN
    DBMS_OUTPUT.PUT_LINE('Utworzono potok MESSAGE_INBOX.');
  END IF;

EXCEPTION

  -- Zgasza oglny wyjtek
  WHEN others THEN
    DBMS_OUTPUT.PUT_LINE(SQLERRM);
    RETURN;

END;
/    

