/*
 * create_messenger.sql
 * Rozdzia 11, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt tworzy pakiet do przesyania komunikatw midzy
 * uytkownikami
 *
 * Wystpuj tu zalenoci dotyczce nazw potokw do wymiany
 * komunikatw. Upewnij si, e we wszystkich schematach
 * uywanych w tecie uruchomiono skrypt create_pipe3.sql
 * Wystarczy te umieci ten skrypt w tym samym katalogu,
 * co niniejszy kod, dziki czemu mona go wywoa
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Wywoanie skryptu tworzcego potoki lokalne
@create_pipe3.sql

-- Specyfikacja pakietu
CREATE OR REPLACE PACKAGE messenger IS

  -- Specyfikacja funkcji
  FUNCTION send_message
    (user_name      VARCHAR2
    ,message        VARCHAR2
    ,message_box    VARCHAR2 DEFAULT 'MESSAGE_INBOX')
    RETURN INTEGER;

  -- Define function specification.
  FUNCTION receive_message
    RETURN VARCHAR2;

END messenger;
/

-- Wywietla bdy, ktre wystpiy przy tworzeniu specyfikacji
show errors

-- Ciao pakietu
CREATE OR REPLACE PACKAGE BODY messenger IS

  -- Definicja funkcji lokalnej zwracajcej nazw uytkownika 
  FUNCTION get_user 
    RETURN VARCHAR2 IS

  BEGIN

    -- Kursorowa ptla for do pobierania nazwy uytkownika 
    FOR i IN (SELECT user FROM dual) LOOP

      -- Zwracanie nazwy uytkownika 
      return i.user;

    END LOOP;
 
  END get_user;
  
  -- Implementacja funkcji pakietu zdefiniowanej w jego specyfikacji
  FUNCTION send_message
    (user_name      VARCHAR2
    ,message        VARCHAR2
    ,message_box    VARCHAR2 DEFAULT 'MESSAGE_INBOX')
    RETURN INTEGER IS

    -- Definicja zmiennej na skrzynk komunikatw wychodzcych
    message_pipe    VARCHAR2(100 CHAR);

  BEGIN

    -- Usunicie zawartoci potoku lokalnego
    DBMS_PIPE.RESET_BUFFER;

    -- Deklaracja skrzynki na komunikaty wychodzce
    message_pipe := UPPER(user_name) || '$'
                 || UPPER(message_box);

    -- Umieszcza komunikat w buforze lokalnym 
    DBMS_PIPE.PACK_MESSAGE(message);

    -- Przesyanie komunikatu; zero oznacza powodzenie
    IF (DBMS_PIPE.send_message(message_pipe) = 0) THEN

      -- Przesano komunikat, dlatego naley zwrci 0
      RETURN 0;

    ELSE

      -- Nie przesano komunikatu, dlatego trzeba zwrci 1
      RETURN 1;

    END IF; 

  END send_message;
  
  -- Implementacja funkcji pakietu zdefiniowanej w specyfikacji
  FUNCTION receive_message
    RETURN VARCHAR2 IS

    -- Definicja zmiennej na skrzynk komunikatw przychodzcych
    message         VARCHAR2(4000 CHAR) :=  NULL;
    message_box     VARCHAR2(100 CHAR);
    inbox           VARCHAR2(14 CHAR) := 'MESSAGE_INBOX';
    timeout         INTEGER := 0;
    return_code     INTEGER;

  BEGIN

    -- Usunicie zawartoci potoku lokalnego
    DBMS_PIPE.RESET_BUFFER;

    -- Deklaracja docelowej skrzynki na komunikaty przychodzce
    message_box := get_user || '$' || inbox;

    -- Umieszcza komunikat w buforze lokalnym 
    return_code := DBMS_PIPE.receive_message(message_box,timeout);

    -- Sprawdza i przetwarza zmienn return_code
    CASE return_code
      WHEN 0 THEN 

        -- Wczytuje komunikat ze zmiennej
        DBMS_PIPE.UNPACK_MESSAGE(message);

      WHEN 1 THEN

      -- Przypisanie komunikatu 
      message := 'Potok komunikatow jest pusty.';

      WHEN 2 THEN 

      -- Przypisanie komunikatu 
      message := 'Komunikat przekracza pojemnosc zmiennej.';

      WHEN 3 THEN 

      -- Przypisanie komunikatu 
      message := 'Wystapila awaria. Skontaktuj sie z administratorem.';

    END CASE;

    -- Zwraca komunikat
    RETURN message;

  END receive_message;

END messenger;
/

-- Wywietla bdy, ktre wystpiy przy tworzeniu ciaa
show errors
