/*
 * firingOrder.sql
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje kolejno uruchamiania wyzwalaczy zdefiniowanych przez uytkownika
 */

SET ECHO ON

BEGIN
  FOR i IN (SELECT   null
            FROM     user_sequences
            WHERE    sequence_name = 'trig_seq') LOOP
    EXECUTE IMMEDIATE 'DROP SEQUENCE trig_seq';
  END LOOP;
END;
/

CREATE SEQUENCE trig_seq
  START WITH 1
  INCREMENT BY 1;

CREATE OR REPLACE PACKAGE TrigPackage AS
  -- Globalny licznik uywany w wyzwalaczach
  v_Counter NUMBER;
END TrigPackage;
/
show errors

CREATE OR REPLACE TRIGGER BooksBStatement
  BEFORE UPDATE ON books
BEGIN
  -- Pocztkowe wyzerowanie licznika
  TrigPackage.v_Counter := 0;
  
  INSERT INTO temp_table (num_col, char_col)
    VALUES (trig_seq.NEXTVAL,
      'Przed instrukcja: counter = ' || TrigPackage.v_Counter);

  -- Zwikszanie wartoci licznika dla nastpnego wyzwalacza
  TrigPackage.v_Counter := TrigPackage.v_Counter + 1;
END BooksBStatement;
/
show errors

CREATE OR REPLACE TRIGGER BooksAStatement1
  AFTER UPDATE ON books
BEGIN
  INSERT INTO temp_table (num_col, char_col)
    VALUES (trig_seq.NEXTVAL,
      'Po instrukcji 1: counter = ' || TrigPackage.v_Counter);

  -- Zwikszanie wartoci licznika dla nastpnego wyzwalacza
  TrigPackage.v_Counter := TrigPackage.v_Counter + 1;
END BooksAStatement1;
/
show errors

CREATE OR REPLACE TRIGGER BooksAStatement2
  AFTER UPDATE ON books
BEGIN
  INSERT INTO temp_table (num_col, char_col)
    VALUES (trig_seq.NEXTVAL,
      'Po instrukcji 2: counter = ' || TrigPackage.v_Counter);

  -- Zwikszanie wartoci licznika dla nastpnego wyzwalacza
  TrigPackage.v_Counter := TrigPackage.v_Counter + 1;
END BooksAStatement2;
/
show errors

CREATE OR REPLACE TRIGGER BooksBRow1
  BEFORE UPDATE ON books
  FOR EACH ROW
BEGIN
  INSERT INTO temp_table (num_col, char_col)
    VALUES (trig_seq.NEXTVAL,
      'Przed wierszem 1: counter = ' || TrigPackage.v_Counter);

  -- Zwikszanie wartoci licznika dla nastpnego wyzwalacza
  TrigPackage.v_Counter := TrigPackage.v_Counter + 1;
END BooksBRow1;
/
show errors

CREATE OR REPLACE TRIGGER BooksBRow2
  BEFORE UPDATE ON books
  FOR EACH ROW
BEGIN
  INSERT INTO temp_table (num_col, char_col)
    VALUES (trig_seq.NEXTVAL,
      'Przed wierszem 2: counter = ' || TrigPackage.v_Counter);

  -- Zwikszanie wartoci licznika dla nastpnego wyzwalacza
  TrigPackage.v_Counter := TrigPackage.v_Counter + 1;
END BooksBRow2;
/
show errors

CREATE OR REPLACE TRIGGER BooksBRow3
  BEFORE UPDATE ON books
  FOR EACH ROW
BEGIN
  INSERT INTO temp_table (num_col, char_col)
    VALUES (trig_seq.NEXTVAL,
      'Przed wierszem 3: counter = ' || TrigPackage.v_Counter);

  -- Zwikszanie wartoci licznika dla nastpnego wyzwalacza
  TrigPackage.v_Counter := TrigPackage.v_Counter + 1;
END BooksBRow3;
/
show errors

CREATE OR REPLACE TRIGGER BooksARow
  AFTER UPDATE ON books
  FOR EACH ROW
BEGIN
  INSERT INTO temp_table (num_col, char_col)
    VALUES (trig_seq.NEXTVAL,
      'Po wierszu: counter = ' || TrigPackage.v_Counter);

  -- Zwikszanie wartoci licznika dla nastpnego wyzwalacza

  TrigPackage.v_Counter := TrigPackage.v_Counter + 1;
END BooksARow;
/
show errors

DELETE temp_table;

UPDATE books
  SET category = category
  WHERE category = 'Oracle Ebusiness';

SELECT *
  FROM temp_table
  ORDER BY num_col;
