/*
 * Logger.java
 * Rozdzia 10, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje klas jzyka Java wywoywan w wyzwalaczu
 */

import java.sql.*;
import oracle.jdbc.driver.*;

public class Logger {
  public static void LogConnect(String userID)
    throws SQLException {
    // Pobieranie domylnego poczenia JDBC
    Connection conn = new OracleDriver().defaultConnection();

    String insertString =
      "INSERT INTO connect_audit (user_name, operation, timestamp)" +
      "  VALUES (?, 'CONNECT', SYSDATE)";

    // Przygotowanie i wykonanie instrukcji odpowiedzialnej za wstawianie danych
    PreparedStatement insertStatement =
      conn.prepareStatement(insertString);
    insertStatement.setString(1, userID);
    insertStatement.execute();
  }

  public static void LogDisconnect(String userID)
    throws SQLException {
    // Pobieranie domylnego poczenia JDBC 
    Connection conn = new OracleDriver().defaultConnection();

    String insertString =
      "INSERT INTO connect_audit (user_name, operation, timestamp)" +
      "  VALUES (?, 'DISCONNECT', SYSDATE)";

    // Przygotowanie i wykonanie instrukcji odpowiedzialnej za wstawianie danych
    PreparedStatement insertStatement =
      conn.prepareStatement(insertString);
    insertStatement.setString(1, userID);
    insertStatement.execute();
  }
}
