/*
 * recreateRTA.sql
 * Rozdzia 9, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt tworzy procedur RecordThreeAuthors
 */

-- Przyznawanie uprawnie uytkownikowi USERB
GRANT SELECT ON books TO USERB;
GRANT EXECUTE ON ThreeAuthors to USERB;

-- Tworzenie tabeli temp_table
CREATE TABLE temp_table (
  num_col    NUMBER,
  char_col   VARCHAR2(60)
);

-- Ponowne utworzenie procedury
CREATE OR REPLACE PROCEDURE RecordThreeAuthors AS
  CURSOR c_Books IS
    SELECT *
      FROM UserA.books;
BEGIN
  FOR v_BookRecord in c_Books LOOP
    -- Zapisuje w tabeli temp_table wszystkie ksiki, ktre
    -- maj trzech autorw
    IF UserA.ThreeAuthors(v_BookRecord.ISBN) THEN
      INSERT INTO temp_table (char_col) VALUES
        (v_BookRecord.title || ' ma trzech autorow');
    END IF;
  END LOOP;
END RecordThreeAuthors;
/
