/*
 * forwardDeclarations.sql
 * Rozdzia 9, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje wzajemnie zalene od siebie podprogramy
 */

set serveroutput on

DECLARE
  v_TempVal BINARY_INTEGER := 5;

  -- Procedura lokalna A. Naley zwrci uwag na fakt, e A wywouje procedur B
  PROCEDURE A(p_Counter IN OUT BINARY_INTEGER) IS
  BEGIN
    DBMS_OUTPUT.PUT_LINE('A(' || p_Counter || ')');
    IF p_Counter > 0 THEN
      B(p_Counter);
      p_Counter := p_Counter - 1;
    END IF;
  END A;

  -- Procedura lokalna B. Naley zwrci uwag na to, e B wywouje procedur A
  PROCEDURE B(p_Counter IN OUT BINARY_INTEGER) IS
  BEGIN
    DBMS_OUTPUT.PUT_LINE('B(' || p_Counter || ')');
    p_Counter := p_Counter - 1;
    A(p_Counter);
  END B;
BEGIN
  B(v_TempVal);
END;
/

-- Mona rozwiza problem, dodajc deklaracj uprzedzajc procedury B
DECLARE
  v_TempVal BINARY_INTEGER := 5;

  -- Deklaracja uprzedzajca procedury B
  PROCEDURE B(p_Counter IN OUT BINARY_INTEGER);

  PROCEDURE A(p_Counter IN OUT BINARY_INTEGER) IS
  BEGIN
    DBMS_OUTPUT.PUT_LINE('A(' || p_Counter || ')');
    IF p_Counter > 0 THEN
      B(p_Counter);
      p_Counter := p_Counter - 1;
    END IF;
  END A;

  PROCEDURE B(p_Counter IN OUT BINARY_INTEGER) IS
  BEGIN
    DBMS_OUTPUT.PUT_LINE('B(' || p_Counter || ')');
    p_Counter := p_Counter - 1;
    A(p_Counter);
  END B;
BEGIN
  B(v_TempVal);
END;
/
