/*
 * automaticInvalidation.sql
 * Rozdzia 9, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje automatyczne oznaczanie podprogramw jako nieprawidowych
 */

COLUMN object_name FORMAT a20

-- Na pocztku obie procedury powinny by prawidowe
SELECT object_name, status
  FROM user_objects
  WHERE object_name IN ('THREEAUTHORS', 'RECORDTHREEAUTHORS');

-- Modyfikacja tabeli books przy uyciu polecenia ddl
ALTER TABLE books MODIFY
  (title VARCHAR2(150)  -- Zwikszenie rozmiaru kolumny title
);

-- Teraz obie procedury powinny by nieprawidowe
SELECT object_name, status
  FROM user_objects
  WHERE object_name IN ('THREEAUTHORS', 'RECORDTHREEAUTHORS');

-- Jednak wywoanie procedury RecordThreeAuthors powinno spowodowa jej automatyczn
-- ponown kompilacj
BEGIN
  RecordThreeAuthors;
END;
/

-- Teraz obie procedury powinny by prawidowe
SELECT object_name, status
  FROM user_objects
  WHERE object_name IN ('THREEAUTHORS', 'RECORDTHREEAUTHORS');
