/*
 * Simple.sql
 * Rozdzia 9, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje widoki sownika danych dla prawidowych i nieprawidowych
 * obiektw
 */

-- Prosta procedura
CREATE OR REPLACE PROCEDURE Simple AS
  v_Counter NUMBER;
BEGIN
  v_Counter := 7;
END Simple;
/

COLUMN object_name format a20
COLUMN line format 9999
COLUMN position format 99999
COLUMN text format a59

-- Te zapytania pokazuj, e procedura jest prawidowa,
-- a obiekt rdowy jest przechowywany w sowniku danych
SELECT object_name, object_type, status
  FROM user_objects
  WHERE object_name = 'SIMPLE';
  
SELECT text
  FROM user_source
  WHERE name = 'SIMPLE'
  ORDER BY line;
  
SELECT line, position, text
  FROM user_errors
  WHERE name = 'SIMPLE'
  ORDER BY sequence;

-- Ponowne utworzenie procedury Simple - tym razem z bdem kompilacji (zwr uwag
-- na brak rednika).
CREATE OR REPLACE PROCEDURE Simple AS
  v_Counter NUMBER;
BEGIN
  v_Counter := 7
END Simple;
/

-- To samo zapytanie pokazuje teraz, e procedura jest nieprawidowa, a
-- tabela user_errors zawiera bdy
SELECT object_name, object_type, status
  FROM user_objects
  WHERE object_name = 'SIMPLE';
  
SELECT text
  FROM user_source
  WHERE name = 'SIMPLE'
  ORDER BY line;
  
SELECT line, position, text
  FROM user_errors
  WHERE name = 'SIMPLE'
  ORDER BY sequence;
