/*
 * parameterModes.sql
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Te procedury su do demonstrowania dziaania parametrw
 * w trybie IN, OUT oraz IN OUT
 */

set serveroutput on format wrapped

-- Ta procedura przyjmuje pojedynczy parametr w trybie IN
CREATE OR REPLACE PROCEDURE ModeIn (
  p_InParameter IN NUMBER) AS
  
  v_LocalVariable NUMBER := 0;
BEGIN
  DBMS_OUTPUT.PUT('W ModeIn: ');
  IF (p_InParameter IS NULL) THEN
    DBMS_OUTPUT.PUT_LINE('p_InParameter ma wartosc NULL');
  ELSE
    DBMS_OUTPUT.PUT_LINE('p_InParameter = ' || p_InParameter);
  END IF;

  /* Przypisanie p_InParameter do v_LocalVariable. Ta operacja jest dozwolona,
     poniewa program odczytuje warto parametru IN, ale nie zapisuje
     jej */
  v_LocalVariable := p_InParameter;
  
  DBMS_OUTPUT.PUT('Na komcu ModeIn: ');
  IF (p_InParameter IS NULL) THEN
    DBMS_OUTPUT.PUT_LINE('p_InParameter ma wartosc NULL');
  ELSE
    DBMS_OUTPUT.PUT_LINE('p_InParameter = ' || p_InParameter);
  END IF;
END ModeIn;

show errors


DECLARE
  v_In NUMBER := 1;
BEGIN
  -- Wywoanie ModeIn ze zmienn, ktrej warto nie powinna si zmieni
  DBMS_OUTPUT.PUT_LINE('Przed wywolaniem ModeIn: v_In = ' || v_In);
  ModeIn(v_In);
  DBMS_OUTPUT.PUT_LINE('Po wywolaniu ModeIn: v_In = ' || v_In);
END;
/

-- Ta procedura przyjmuje pojedynczy parametr w trybie OUT
CREATE OR REPLACE PROCEDURE ModeOut (
  p_OutParameter OUT NUMBER) AS
  
  v_LocalVariable NUMBER := 0;
BEGIN
  DBMS_OUTPUT.PUT('W ModeOut: ');
  IF (p_OutParameter IS NULL) THEN
    DBMS_OUTPUT.PUT_LINE('p_OutParameter ma wartosc NULL');
  ELSE
    DBMS_OUTPUT.PUT_LINE('p_OutParameter = ' || p_OutParameter);
  END IF;

  /* Przypisanie 7 do p_OutParameter. Jest to dozwolone, poniewa
     program przypisuje warto do parametru typu OUT */
  p_OutParameter := 7;

  /* Przypisanie p_OutParameter do v_LocalVariable. Take ta operacje jest dozwolona, 
     poniewa program odczytuje warto z parametru typu OUT */
  v_LocalVariable := p_OutParameter;
  
  DBMS_OUTPUT.PUT('Na koncu ModeOut: ');
  IF (p_OutParameter IS NULL) THEN
    DBMS_OUTPUT.PUT_LINE('p_OutParameter ma wartosc NULL');
  ELSE
    DBMS_OUTPUT.PUT_LINE('p_OutParameter = ' || p_OutParameter);
  END IF;
END ModeOut;

/
show errors

DECLARE
  v_Out NUMBER := 1;
BEGIN
  -- Wywoanie procedury ModeOut ze zmienn, ktrej warto powinna si zmieni
  DBMS_OUTPUT.PUT_LINE('Przed wywolaniem ModeOut: v_Out = ' || v_Out);
  ModeOut(v_Out);
  DBMS_OUTPUT.PUT_LINE('Po wywolaniu ModeOut: v_Out = ' || v_Out);
END;
/

-- Ta procedura przyjmuje pojedynczy parametr w trybie IN OUT
CREATE OR REPLACE PROCEDURE ModeInOut (
  p_InOutParameter IN OUT NUMBER) IS

  v_LocalVariable  NUMBER := 0;
BEGIN
  DBMS_OUTPUT.PUT('W ModeInOut: ');
  IF (p_InOutParameter IS NULL) THEN
    DBMS_OUTPUT.PUT_LINE('p_InOutParameter ma wartosc NULL');
  ELSE
    DBMS_OUTPUT.PUT_LINE('p_InOutParameter = ' || p_InOutParameter);
  END IF;

  /* Przypisanie p_InOutParameter do v_LocalVariable. Jest to dozwolone,
     poniewa program wczytuje warto parametru typu IN OUT */
  v_LocalVariable := p_InOutParameter;

  /* Przypisanie 8 do p_InOutParameter. Jest dozwolone, poniewa program 
     przypisuje warto do parametru typu IN OUT */
  p_InOutParameter := 8;
  
  DBMS_OUTPUT.PUT('Na koncu ModeInOut: ');
  IF (p_InOutParameter IS NULL) THEN
    DBMS_OUTPUT.PUT_LINE('p_InOutParameter ma wartosc NULL');
  ELSE
    DBMS_OUTPUT.PUT_LINE('p_InOutParameter = ' || p_InOutParameter);
  END IF;
END ModeInOut;
/
show errors

DECLARE
  v_InOut NUMBER := 1;
BEGIN
    -- Wywoanie ModeInOut przy uyciu zmiennej, ktra ma zosta zmodyfikowana
    DBMS_OUTPUT.PUT_LINE('Przed wywolaniem ModeInOut: v_InOut = ' ||v_InOut);
    ModeInOut(v_InOut);
    DBMS_OUTPUT.PUT_LINE('Po wywolaniu ModeInOut: v_InOut = ' ||v_InOut);
END;
/

BEGIN
  -- Nie mona wywoa ModeOut (ani ModeInOut) przy uyciu staej, poniewa
  -- argument musi okrela miejsce na dane
  ModeOut(3);
END;
/

BEGIN
  -- Mona jednak uy staej do wywoania funkcji ModeIn
  ModeIn(3);
END;
/

-- Ta procedura nie skompiluje si, poniewa prbuje zmodyfikowa
-- parametr IN 
CREATE OR REPLACE PROCEDURE IllegalModeIn (
  p_InParameter IN NUMBER) AS
BEGIN
  /* Przypisanie 7 do p_InParameter. Jest to NIEDOZWOLONE, poniewa
     program prbuje przypisa warto do parametru typu IN */
  p_InParameter := 7;
END IllegalModeIn;
/
show errors
