/*
 * ParameterLength.sql
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt ilustruje ograniczenia zwizane z parametrami formalnymi
 */
 
-- Ta definicja jest niedozwolona i spowoduje bd kompilacji
CREATE OR REPLACE PROCEDURE ParameterLength (
  p_Parameter1 IN OUT VARCHAR2(10),
  p_Parameter2 IN OUT NUMBER(3,1)) AS
BEGIN
  p_Parameter1 := 'abcdefghijklm'; -- 15 znakw dugoci
  p_Parameter2 := 12.3;
END ParameterLength;
/
show errors

-- Z kolei ta definicja jest poprawna
CREATE OR REPLACE PROCEDURE ParameterLength (
  p_Parameter1 IN OUT VARCHAR2,
  p_Parameter2 IN OUT NUMBER) AS
BEGIN
  p_Parameter1 := 'abcdefghijklmno'; -- 15 znakw dugoci
  p_Parameter2 := 12.3;
END ParameterLength;
/
show errors

-- Wywoanie procedury ParameterLength(). Obowizuj ograniczenia
-- z argumentw
DECLARE
  v_Variable1 VARCHAR2(40);
  v_Variable2 NUMBER(7,3);
BEGIN
  ParameterLength(v_Variable1, v_Variable2);
END;
/

-- Ponowne wywoanie procedury ParameterLength().  Poniewa ograniczenia
-- pochodz z argumentw, ten kod zgosi wyjtek ORA-6502
DECLARE
  v_Variable1 VARCHAR2(10);
  v_Variable2 NUMBER(7,3);
BEGIN
  ParameterLength(v_Variable1, v_Variable2);
END;
/

-- W tej wersji procedury ParameterLength() parametr p_Parameter2
-- jest ograniczony z powodu deklaracji %TYPE
CREATE OR REPLACE PROCEDURE ParameterLength (
  p_Parameter1 IN OUT VARCHAR2,
  p_Parameter2 IN OUT books.copyright%TYPE) AS
BEGIN
  p_Parameter2 := 12345;
END ParameterLength;
/
show errors

DECLARE
  v_Variable1 VARCHAR2(1);
  -- Deklaracja zmiennej v_Variable2 bez ogranicze
  v_Variable2 NUMBER;
BEGIN
  -- Cho argument ma miejsce na tekst 12345, program
  -- uwzgldnia ograniczenie parametru formalnego, co powoduje
  -- zgoszenie bdu ORA-6502 przy prbie wywoania procedury
  ParameterLength(v_Variable1, v_Variable2);
END;
/


