/*
 * NoCopyTest.sql
 * Rozdzia 8, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje dziaanie modyfikatora NOCOPY
 */
 
-- Ta procedura demonstruje skadni stosowania wskazwki NOCOPY dla kompilatora
CREATE OR REPLACE PROCEDURE NoCopyTest (
  p_InParameter    IN NUMBER,
  p_OutParameter   OUT NOCOPY VARCHAR2,
  p_InOutParameter IN OUT NOCOPY CHAR) IS
BEGIN
  NULL;
END NoCopyTest;
/

-- Zmodyfikowana wersja procedury RaiseError, w ktrej parametr OUT
-- ma modyfikator NOCOPY
CREATE OR REPLACE PROCEDURE RaiseErrorNoCopy (
  p_Raise IN BOOLEAN,
  p_ParameterA OUT NOCOPY NUMBER) AS
BEGIN
  p_ParameterA := 7;
  IF p_Raise THEN
    RAISE DUP_VAL_ON_INDEX;
  ELSE
    RETURN;
  END IF;
END RaiseErrorNoCopy;
/

-- Przy wywoywaniu procedury RaiseErrorNoCopy dziaanie wyjtkw jest inne
-- z powodu zastosowania modyfikatora NOCOPY
DECLARE
  v_Num NUMBER := 1;
BEGIN
  DBMS_OUTPUT.PUT_LINE('Wartosc przed pierwszym wywolaniem: ' || v_Num);
  RaiseErrorNoCopy(FALSE, v_Num);
  DBMS_OUTPUT.PUT_LINE('Wartosc po udanym wywolaniu: ' || v_Num);
  DBMS_OUTPUT.PUT_LINE('');
  
  v_Num := 2;
  DBMS_OUTPUT.PUT_LINE('Wartosc przed drugim wywolaniem: ' || v_Num);
  RaiseErrorNoCopy(TRUE, v_Num);
EXCEPTION
  WHEN OTHERS THEN
    DBMS_OUTPUT.PUT_LINE('Wartosc po nieudanym wywolaniu: ' || v_Num);
END;
/
