/*
 * nestedtable_dml2.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje aktualizowanie tabel zagniedonych
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Porzdkowanie rodowiska
BEGIN

  FOR i IN (SELECT   null
            FROM     addresses
            WHERE    address_id = 21) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM addresses WHERE address_id = 21';
  END LOOP;

  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 21) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 21';
  END LOOP;

  COMMIT;

END;
/

-- Wstawianie danych do tabeli individuals z powodu ograniczenia zwizanego z kluczem nadrzdnym
INSERT
INTO     individuals
VALUES
('21'
,'Jan'
,''
,'Kowalski');

-- Wstawianie danych do tabeli addresses przy uyciu tabeli zagniedonej
INSERT
INTO     addresses
VALUES
(21
,21
,address_table
  ('Biuro senatora Kowalskiego'
  ,'Zachodnia 1'
  ,'Apartament 200')
,'Warszawa'
,'MAZ'
,'85-701'
,'PL');

-- Wstawianie danych do tabeli addresses przy uyciu tabeli zagniedonej
UPDATE   addresses
SET      street_address = 
           address_table('Biuro senatora Kowalskiego'
                         ,'Wschodnia 7'
                         ,'Apartament 1150')
WHERE    address_id = 21;

SELECT   column_value
FROM     THE (SELECT   street_address
              FROM     addresses
              WHERE    address_id = 21);
